/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowPropertyEditor;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.opensymphony.workflow.loader.ActionDescriptor;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public abstract class WorkflowTransitionResource {
    private static final String PROPERTIES_PATH = "{id}/properties";

    private WorkflowTransitionResource() {
    }

    @GET
    @Path(value="{id}/properties")
    @Operation(summary="Get properties for a transition", description="Return the property or properties associated with a transition.")
    @Parameters(value={@Parameter(name="id", in=ParameterIn.PATH, description="The ID of the transition within the workflow.", required=true), @Parameter(name="includeReservedKeys", in=ParameterIn.QUERY, description="Some keys under the \"jira.\" prefix are editable, some are not. Set this to true in order to include the non-editable keys in the response."), @Parameter(name="key", in=ParameterIn.QUERY, description="The name of the property key to query. Can be left off the query to return all properties."), @Parameter(name="workflowName", in=ParameterIn.QUERY, description="The name of the workflow to use."), @Parameter(name="workflowMode", in=ParameterIn.QUERY, description="The type of workflow to use. Can either be \"live\" or \"draft\".")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returned if the currently authenticated user has administration permission. Contains a full representation of every workflow.", content={@Content(schema=@Schema(implementation=PropertyBean.class), mediaType="application/json")}), @ApiResponse(responseCode="403", description="Returned if the currently authenticated user does not have administration permission.")})
    public abstract Response getProperties(@PathParam(value="id") long var1, @QueryParam(value="includeReservedKeys") boolean var3, @QueryParam(value="key") String var4, @QueryParam(value="workflowName") String var5, @QueryParam(value="workflowMode") String var6);

    @POST
    @WebSudoRequired
    @Path(value="{id}/properties")
    @Operation(summary="Create a property for a transition", description="Add a new property to a transition. Trying to add a property that already exists will fail.")
    @Parameters(value={@Parameter(name="id", in=ParameterIn.PATH, description="The ID of the transition within the workflow.", required=true), @Parameter(name="key", in=ParameterIn.QUERY, description="The name of the property to add."), @Parameter(name="workflowName", in=ParameterIn.QUERY, description="The name of the workflow to use."), @Parameter(name="workflowMode", in=ParameterIn.QUERY, description="The type of workflow to use. Can either be \"live\" or \"draft\".")})
    @RequestBody(description="The new property to create. If the \"key\" is passed it must match the value in the \"key\" query parameter of the request.", required=true, content={@Content(schema=@Schema(implementation=PropertyBean.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returned if the currently authenticated user has administration permission. Contains a full representation of every workflow.", content={@Content(schema=@Schema(implementation=PropertyBean.class), mediaType="application/json")}), @ApiResponse(responseCode="400", description="Returned if the request is invalid."), @ApiResponse(responseCode="403", description="Returned if the user does not have admin permission")})
    public abstract Response createProperty(@PathParam(value="id") long var1, @QueryParam(value="key") String var3, @QueryParam(value="workflowName") String var4, @QueryParam(value="workflowMode") String var5, PropertyBean var6);

    @PUT
    @WebSudoRequired
    @Path(value="{id}/properties")
    @Operation(summary="Update a property for a transition", description="Update/add new property to a transition. Trying to update a property that does not exist will result in a new property being added.")
    @Parameters(value={@Parameter(name="id", in=ParameterIn.PATH, description="The ID of the transition within the workflow.", required=true), @Parameter(name="key", in=ParameterIn.QUERY, description="The name of the property to add."), @Parameter(name="workflowName", in=ParameterIn.QUERY, description="The name of the workflow to use."), @Parameter(name="workflowMode", in=ParameterIn.QUERY, description="The type of workflow to use. Can either be \"live\" or \"draft\".")})
    @RequestBody(description="The new property to create. If the \"key\" is passed it must match the value in the \"key\" query parameter of the request.", required=true, content={@Content(schema=@Schema(implementation=PropertyBean.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returned if the currently authenticated user has administration permission. Contains a full representation of every workflow.", content={@Content(schema=@Schema(implementation=PropertyBean.class), mediaType="application/json")}), @ApiResponse(responseCode="304", description="Returned if no changes were actually made by the request (e.g. updating a property to value it already holds)."), @ApiResponse(responseCode="400", description="Returned if the request is invalid."), @ApiResponse(responseCode="403", description="Returned if the user does not have admin permission")})
    public abstract Response updateProperty(@PathParam(value="id") long var1, @QueryParam(value="key") String var3, @QueryParam(value="workflowName") String var4, @QueryParam(value="workflowMode") String var5, PropertyBean var6);

    @DELETE
    @WebSudoRequired
    @Path(value="{id}/properties")
    @Operation(summary="Delete a property for a transition", description="Delete a property from the passed transition on the passed workflow. It is not an error to delete a property that does not exist.")
    @Parameters(value={@Parameter(name="id", in=ParameterIn.PATH, description="The ID of the transition within the workflow.", required=true), @Parameter(name="key", in=ParameterIn.QUERY, description="The name of the property to add."), @Parameter(name="workflowName", in=ParameterIn.QUERY, description="The name of the workflow to use."), @Parameter(name="workflowMode", in=ParameterIn.QUERY, description="The type of workflow to use. Can either be \"live\" or \"draft\".")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returned if the currently authenticated user has administration permission. Contains a full representation of every workflow."), @ApiResponse(responseCode="304", description="Returned if no changes were actually made by the request (e.g. trying to delete a property that does not exist)."), @ApiResponse(responseCode="400", description="Returned if the request is invalid."), @ApiResponse(responseCode="403", description="Returned if the user does not have admin permission")})
    public abstract Response deleteProperty(@PathParam(value="id") long var1, @QueryParam(value="key") String var3, @QueryParam(value="workflowName") String var4, @QueryParam(value="workflowMode") String var5);

    private static final class Responses {
        private Responses() {
        }

        private static Response badRequest(String key, String message) {
            return Responses.forMessage(key, message, Response.Status.BAD_REQUEST);
        }

        private static Response notFound(String key, String message) {
            return Responses.forMessage(key, message, Response.Status.NOT_FOUND);
        }

        private static Response notModified() {
            return Responses.build(Response.notModified());
        }

        private static Response forCollection(com.atlassian.jira.util.ErrorCollection collection) {
            return Responses.forCollection(collection, ErrorCollection.Reason.SERVER_ERROR);
        }

        private static Response forCollection(com.atlassian.jira.util.ErrorCollection collection, ErrorCollection.Reason defaultReason) {
            if (!collection.hasAnyErrors()) {
                throw new IllegalArgumentException("collection has no errors.");
            }
            if (defaultReason == null) {
                throw new IllegalArgumentException("defaultReason is null");
            }
            ErrorCollection.Reason worstReason = ErrorCollection.Reason.getWorstReason((Collection)collection.getReasons());
            if (worstReason == null) {
                worstReason = defaultReason;
            }
            return Responses.build(Response.status((int)worstReason.getHttpStatusCode()).entity((Object)ErrorCollection.of(collection)));
        }

        private static Response forMessage(String key, String message, Response.Status status) {
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            errorCollection.addError(key, message);
            return Responses.build(Response.status((Response.Status)status).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection)));
        }

        private static Response ok(Object bean) {
            return Responses.build(Response.ok((Object)bean));
        }

        private static Response ok() {
            return Responses.build(Response.ok());
        }

        private static Response build(Response.ResponseBuilder builder) {
            return builder.cacheControl(CacheControl.never()).build();
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PropertyBean {
        private final String key;
        private final String value;

        @JsonCreator
        public PropertyBean(@JsonProperty(value="key") String key, @JsonProperty(value="value") String value) {
            this.key = key;
            this.value = value;
        }

        @JsonProperty
        public String getKey() {
            return this.key;
        }

        @JsonProperty
        public String getValue() {
            return this.value;
        }

        @JsonProperty
        public String getId() {
            return this.getKey();
        }
    }

    public static enum WorkflowMode {
        DRAFT,
        LIVE;


        public static WorkflowMode getMode(String name) {
            if (name == null) {
                return LIVE;
            }
            for (WorkflowMode mode : WorkflowMode.values()) {
                if (!mode.name().equalsIgnoreCase(name)) continue;
                return mode;
            }
            return null;
        }
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public static class ConstantResponseResource
    extends WorkflowTransitionResource {
        private final Response response;

        @Inject
        ConstantResponseResource(Response response) {
            this.response = response;
        }

        @Override
        @GET
        @Path(value="{id}/properties")
        @ApiResponse(description="Placeholder", responseCode="200")
        public Response getProperties(@PathParam(value="id") long transitionId, @QueryParam(value="includeReservedKeys") boolean includeReservedKeys, @QueryParam(value="key") String key, @QueryParam(value="workflowName") String workflowName, @QueryParam(value="workflowMode") String workflowMode) {
            return this.response;
        }

        @Override
        @POST
        @WebSudoRequired
        @Path(value="{id}/properties")
        @ApiResponse(description="Placeholder", responseCode="200")
        public Response createProperty(@PathParam(value="id") long transitionId, @QueryParam(value="key") String key, @QueryParam(value="workflowName") String workflowName, @QueryParam(value="workflowMode") String workflowMode, PropertyBean body) {
            return this.response;
        }

        @Override
        @PUT
        @WebSudoRequired
        @Path(value="{id}/properties")
        @ApiResponse(description="Placeholder", responseCode="200")
        public Response updateProperty(@PathParam(value="id") long transitionId, @QueryParam(value="key") String key, @QueryParam(value="workflowName") String workflowName, @QueryParam(value="workflowMode") String workflowMode, PropertyBean body) {
            return this.response;
        }

        @Override
        @DELETE
        @WebSudoRequired
        @Path(value="{id}/properties")
        @ApiResponse(description="Placeholder", responseCode="200")
        public Response deleteProperty(@PathParam(value="id") long transitionId, @QueryParam(value="key") String key, @QueryParam(value="workflowName") String workflowName, @QueryParam(value="workflowMode") String workflowMode) {
            return this.response;
        }
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public static class TransitionResource
    extends WorkflowTransitionResource {
        private static final String PROPERTY_KEY = "key";
        private static final String TRANSITION_ID = "transitionId";
        private final WorkflowManager workflowManager;
        private final JiraAuthenticationContext ctx;
        private final WorkflowPropertyEditor.WorkflowPropertyEditorFactory factory;
        private final JiraWorkflow workflow;

        @Inject
        TransitionResource(WorkflowManager workflowManager, JiraAuthenticationContext ctx, WorkflowPropertyEditor.WorkflowPropertyEditorFactory factory, JiraWorkflow workflow) {
            this.workflowManager = workflowManager;
            this.ctx = ctx;
            this.factory = factory;
            this.workflow = workflow;
        }

        @Override
        @GET
        @Path(value="{id}/properties")
        @ApiResponses(value={@ApiResponse(description="Operation succeeded", responseCode="200"), @ApiResponse(description="Transition not found", responseCode="404"), @ApiResponse(description="Workflows attribute key mismatch", responseCode="400"), @ApiResponse(description="Property was not modified", responseCode="304")})
        public Response getProperties(@PathParam(value="id") long transitionId, @QueryParam(value="includeReservedKeys") boolean includeReservedKeys, @QueryParam(value="key") String key, @QueryParam(value="workflowName") String workflowName, @QueryParam(value="workflowMode") String workflowMode) {
            Map<Long, ActionDescriptor> actionsMap = this.getActionsMap(this.workflow);
            ActionDescriptor actionDescriptor = actionsMap.get(transitionId);
            if (actionDescriptor == null) {
                return Responses.notFound(TRANSITION_ID, this.ctx.getI18nHelper().getText("admin.errors.workflows.transition.does.not.exist", String.valueOf(transitionId)));
            }
            key = StringUtils.stripToNull((String)key);
            Map<String, String> metaAttributes = this.getMetaAttributes(actionDescriptor);
            if (key == null) {
                ArrayList items = Lists.newArrayListWithCapacity((int)metaAttributes.entrySet().size());
                for (Map.Entry<String, String> s : metaAttributes.entrySet()) {
                    if (!includeReservedKeys && WorkflowUtil.isReservedKey((String)s.getKey())) continue;
                    items.add(new PropertyBean(s.getKey(), s.getValue()));
                }
                return Response.ok((Object)items).cacheControl(CacheControl.never()).build();
            }
            if (metaAttributes.containsKey(key)) {
                return Response.ok((Object)new PropertyBean(key, metaAttributes.get(key))).cacheControl(CacheControl.never()).build();
            }
            String displayKey = key;
            if (StringUtils.isBlank((CharSequence)displayKey)) {
                displayKey = "<blank>";
            }
            return Responses.notFound(PROPERTY_KEY, this.ctx.getI18nHelper().getText("admin.errors.workflows.attribute.key.does.not.exist", displayKey));
        }

        @Override
        @POST
        @WebSudoRequired
        @Path(value="{id}/properties")
        @ApiResponses(value={@ApiResponse(description="Operation succeeded", responseCode="200"), @ApiResponse(description="Transition not found", responseCode="404"), @ApiResponse(description="Workflows attribute key mismatch", responseCode="400"), @ApiResponse(description="Property was not modified", responseCode="304")})
        public Response createProperty(@PathParam(value="id") long transitionId, @QueryParam(value="key") String key, @QueryParam(value="workflowName") String workflowName, @QueryParam(value="workflowMode") String workflowMode, PropertyBean body) {
            return this.createEditOrDeleteProperty(transitionId, key, body, Operation.CREATE);
        }

        @Override
        @PUT
        @WebSudoRequired
        @Path(value="{id}/properties")
        @ApiResponses(value={@ApiResponse(description="Operation succeeded", responseCode="200"), @ApiResponse(description="Transition not found", responseCode="404"), @ApiResponse(description="Workflows attribute key mismatch", responseCode="400"), @ApiResponse(description="Property was not modified", responseCode="304")})
        public Response updateProperty(@PathParam(value="id") long transitionId, @QueryParam(value="key") String key, @QueryParam(value="workflowName") String workflowName, @QueryParam(value="workflowMode") String workflowMode, PropertyBean body) {
            return this.createEditOrDeleteProperty(transitionId, key, body, Operation.UPDATE);
        }

        @Override
        @DELETE
        @WebSudoRequired
        @Path(value="{id}/properties")
        @ApiResponses(value={@ApiResponse(description="Operation succeeded", responseCode="200"), @ApiResponse(description="Transition not found", responseCode="404"), @ApiResponse(description="Workflows attribute key mismatch", responseCode="400"), @ApiResponse(description="Property was not modified", responseCode="304")})
        public Response deleteProperty(@PathParam(value="id") long transitionId, @QueryParam(value="key") String key, @QueryParam(value="workflowName") String workflowName, @QueryParam(value="workflowMode") String workflowMode) {
            return this.createEditOrDeleteProperty(transitionId, key, null, Operation.DELETE);
        }

        private Response createEditOrDeleteProperty(long transitionId, String key, PropertyBean body, Operation operation) {
            JiraWorkflow workflow = this.getWorkflowForEdit();
            Map<Long, ActionDescriptor> actionsMap = this.getActionsMap(workflow);
            ActionDescriptor actionDescriptor = actionsMap.get(transitionId);
            if (actionDescriptor == null) {
                return Responses.notFound(TRANSITION_ID, this.ctx.getI18nHelper().getText("admin.errors.workflows.transition.does.not.exist", String.valueOf(transitionId)));
            }
            if (operation == Operation.UPDATE || operation == Operation.CREATE) {
                if (body.getKey() != null && !body.getKey().equals(key)) {
                    return Responses.badRequest(PROPERTY_KEY, this.ctx.getI18nHelper().getText("admin.errors.workflows.attribute.key.mismatch", key, body.getKey()));
                }
                WorkflowPropertyEditor editor = this.factory.transitionPropertyEditor(workflow, actionDescriptor);
                ServiceOutcome outcome = operation == Operation.UPDATE ? editor.updateProperty(key, body.value) : editor.addProperty(key, body.value);
                if (outcome.isValid()) {
                    WorkflowPropertyEditor.Result result = (WorkflowPropertyEditor.Result)outcome.getReturnedValue();
                    if (!result.isModified()) {
                        return Responses.notModified();
                    }
                    return Responses.ok(new PropertyBean(result.name(), result.value()));
                }
                return Responses.forCollection(outcome.getErrorCollection());
            }
            if (operation == Operation.DELETE) {
                WorkflowPropertyEditor editor = this.factory.transitionPropertyEditor(workflow, actionDescriptor);
                ServiceOutcome outcome = editor.deleteProperty(key);
                if (outcome.isValid()) {
                    WorkflowPropertyEditor.Result result = (WorkflowPropertyEditor.Result)outcome.getReturnedValue();
                    if (!result.isModified()) {
                        return Responses.notModified();
                    }
                    return Responses.ok();
                }
                return Responses.forCollection(outcome.getErrorCollection());
            }
            throw new IllegalStateException("Cannot handle operation '" + operation + "'.");
        }

        private JiraWorkflow getWorkflowForEdit() {
            if (this.workflow.isDraftWorkflow()) {
                return this.workflow;
            }
            return this.workflowManager.getWorkflowClone(this.workflow.getName());
        }

        private Map<String, String> getMetaAttributes(ActionDescriptor actionDescriptor) {
            Map metaAttributes = actionDescriptor.getMetaAttributes();
            return metaAttributes == null ? Collections.emptyMap() : metaAttributes;
        }

        private Map<Long, ActionDescriptor> getActionsMap(JiraWorkflow workflow) {
            return Maps.uniqueIndex((Iterable)workflow.getAllActions(), (Function)new Function<ActionDescriptor, Long>(){

                public Long apply(ActionDescriptor actionDescriptor) {
                    return actionDescriptor.getId();
                }
            });
        }

        private static enum Operation {
            CREATE,
            UPDATE,
            DELETE;

        }
    }

    @Component
    public static class Factory {
        private static final String WORKFLOW_NAME = "workflowName";
        private static final String WORKFLOW_MODE = "workflowMode";
        private final WorkflowManager workflowManager;
        private final JiraAuthenticationContext ctx;
        private final WorkflowService workflowService;
        private final WorkflowPropertyEditor.WorkflowPropertyEditorFactory factory;

        @Autowired
        public Factory(WorkflowManager workflowManager, JiraAuthenticationContext ctx, WorkflowService workflowService, WorkflowPropertyEditor.WorkflowPropertyEditorFactory factory) {
            this.workflowManager = workflowManager;
            this.ctx = ctx;
            this.factory = factory;
            this.workflowService = workflowService;
        }

        WorkflowTransitionResource getResource(String workflowName, WorkflowMode mode) {
            JiraServiceContextImpl context = new JiraServiceContextImpl(this.ctx.getUser());
            if (mode == null) {
                return new ConstantResponseResource(Responses.badRequest(WORKFLOW_MODE, this.ctx.getI18nHelper().getText("admin.errors.workflows.invalid.workflow.mode")));
            }
            JiraWorkflow workflow = mode == WorkflowMode.LIVE ? this.workflowService.getWorkflow((JiraServiceContext)context, workflowName) : this.workflowService.getDraftWorkflow((JiraServiceContext)context, workflowName);
            if (workflow == null) {
                if (context.getErrorCollection().hasAnyErrors()) {
                    return new ConstantResponseResource(Responses.forCollection(context.getErrorCollection(), ErrorCollection.Reason.NOT_FOUND));
                }
                return new ConstantResponseResource(Responses.notFound(WORKFLOW_NAME, this.ctx.getI18nHelper().getText("admin.errors.workflow.with.name.does.not.exist", workflowName)));
            }
            return new TransitionResource(this.workflowManager, this.ctx, this.factory, workflow);
        }
    }
}

