/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.session.cluster.SessionInvalidationReplicatedEvent;
import com.atlassian.jira.web.session.currentusers.UserSessionInvalidatedEvent;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.atlassian.fugue.Either;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="user/session")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@LicensedOnly
public class UserSessionResource {
    private final EventPublisher eventPublisher;
    private final UserManager userManager;
    private final JiraAuthenticationContext authContext;
    private final GlobalPermissionManager permissionManager;

    @Inject
    public UserSessionResource(EventPublisher eventPublisher, UserManager userManager, JiraAuthenticationContext authContext, GlobalPermissionManager permissionManager) {
        this.eventPublisher = eventPublisher;
        this.userManager = userManager;
        this.authContext = authContext;
        this.permissionManager = permissionManager;
    }

    @DELETE
    @Path(value="{username}")
    @WebSudoRequired
    @Operation(summary="Delete user session", description="Invalidates session of given user.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="username", description="a String containing username.", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="Returned when the session is invalidated successfully.", responseCode="200"), @ApiResponse(description="Returned if the user is not logged.", responseCode="401"), @ApiResponse(description="Returned if the user does not have admin permission.", responseCode="403"), @ApiResponse(description="Returned if the username does not exist.", responseCode="404")})
    public Response deleteSession(@PathParam(value="username") String username) {
        Either<Response.Status, ApplicationUser> result = this.prechecks(username);
        result.forEach(user -> {
            this.eventPublisher.publish((Object)new SessionInvalidationReplicatedEvent(user.getUsername()));
            this.eventPublisher.publish((Object)new UserSessionInvalidatedEvent());
        });
        Response.Status resultCode = (Response.Status)result.fold(status -> status, user -> Response.Status.OK);
        return Response.status((Response.Status)resultCode).cacheControl(CacheControl.never()).build();
    }

    private Either<Response.Status, ApplicationUser> prechecks(String username) {
        boolean isAdmin;
        ApplicationUser caller = this.authContext.getLoggedInUser();
        if (caller == null) {
            return Either.left((Object)Response.Status.UNAUTHORIZED);
        }
        boolean bl = isAdmin = this.permissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, caller) || this.permissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, caller);
        if (!isAdmin) {
            return Either.left((Object)Response.Status.FORBIDDEN);
        }
        ApplicationUser user = this.userManager.getUserByName(username);
        if (user == null) {
            return Either.left((Object)Response.Status.NOT_FOUND);
        }
        return Either.right((Object)user);
    }
}

