/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.issue.fields.ColumnService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.issue.ColumnsBean;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.BadRequestWebException;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.rest.v2.search.ColumnOptions;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.UrlValidator;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="settings")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AdminOnly
public class SettingsResource {
    private final ApplicationProperties applicationProperties;
    private final ColumnService columnService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final GlobalPermissionManager globalPermissionManager;
    private final I18nHelper i18n;

    @Inject
    public SettingsResource(ApplicationProperties applicationProperties, ColumnService columnService, JiraAuthenticationContext jiraAuthenticationContext, GlobalPermissionManager globalPermissionManager, I18nHelper i18n) {
        this.applicationProperties = applicationProperties;
        this.columnService = columnService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.globalPermissionManager = globalPermissionManager;
        this.i18n = i18n;
    }

    @GET
    @WebSudoRequired
    @Path(value="columns")
    @Operation(summary="Get default system columns for issue navigator", description="Returns the default system columns for issue navigator. Admin permission will be required.", security={@SecurityRequirement(name="basic")})
    @ApiResponses(value={@ApiResponse(description="Returns a list of columns for configured for the given user.", responseCode="200", content={@Content(schema=@Schema(implementation=ColumnOptions.class), mediaType="application/json")}), @ApiResponse(description="Returned if the user does not have admin permission.", responseCode="403"), @ApiResponse(description="Returned if an error occurs while retrieving the column configuration.", responseCode="500")})
    public Response getIssueNavigatorDefaultColumns() {
        ApplicationUser currentUser = this.jiraAuthenticationContext.getUser();
        ServiceOutcome outcome = this.columnService.getDefaultColumnLayout(currentUser);
        if (outcome.isValid()) {
            List columnLayoutItems = ((ColumnLayout)outcome.getReturnedValue()).getColumnLayoutItems();
            return Response.ok(ColumnOptions.toColumnOptions(columnLayoutItems)).cacheControl(CacheControl.never()).build();
        }
        throw new RESTException(ErrorCollection.of(outcome.getErrorCollection()));
    }

    @PUT
    @WebSudoRequired
    @Path(value="columns")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Operation(summary="Set default system columns for issue navigator using form", description="Sets the default system columns for issue navigator. Admin permission will be required.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="columns", description="List of column ids.", in=ParameterIn.DEFAULT, required=true)
    @ApiResponses(value={@ApiResponse(description="Returned when the columns is saved successfully.", responseCode="200"), @ApiResponse(description="Returned if an error occurs while retrieving the column configuration.", responseCode="500")})
    public Response setIssueNavigatorDefaultColumnsForm(@FormParam(value="columns") List<String> fields) {
        ApplicationUser currentUser = this.jiraAuthenticationContext.getUser();
        ServiceResult outcome = this.columnService.setDefaultColumns(currentUser, fields);
        if (outcome.isValid()) {
            return Response.ok().cacheControl(CacheControl.never()).build();
        }
        throw new RESTException(ErrorCollection.of(outcome.getErrorCollection()));
    }

    @PUT
    @WebSudoRequired
    @Path(value="columns")
    @Consumes(value={"application/json"})
    @ApiResponse(description="Returned when the default columns are saved successfully.", responseCode="200")
    public Response setIssueNavigatorDefaultColumns(ColumnsBean columns) {
        ApplicationUser currentUser = this.jiraAuthenticationContext.getUser();
        ServiceResult outcome = this.columnService.setDefaultColumns(currentUser, columns.getColumns());
        if (outcome.isValid()) {
            return Response.ok().cacheControl(CacheControl.never()).build();
        }
        throw new RESTException(ErrorCollection.of(outcome.getErrorCollection()));
    }

    @PUT
    @SystemAdminOnly
    @WebSudoRequired
    @Path(value="baseUrl")
    @Operation(summary="Update base URL for Jira instance", description="Sets the base URL that is configured for this Jira instance.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="baseURL", description="a String containing the base URL that will be set for this Jira instance.", in=ParameterIn.DEFAULT, required=true)
    @ApiResponses(value={@ApiResponse(description="Returned when the base url is saved successfully.", responseCode="200"), @ApiResponse(description="Returned if the specified base URL is not valid.", responseCode="400")})
    public void setBaseURL(String baseURL) {
        if (!this.isSysAdmin(this.jiraAuthenticationContext.getUser())) {
            throw new NotAuthorisedWebException(ErrorCollection.of(this.i18n.getText("rest.settings.baseurl.permission.denied")));
        }
        if (!UrlValidator.isValid((String)baseURL)) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("rest.settings.baseurl.invalid")));
        }
        this.applicationProperties.setString("jira.baseurl", baseURL);
    }

    private boolean isSysAdmin(ApplicationUser currentUser) {
        return currentUser != null && this.globalPermissionManager.hasPermission(44, currentUser);
    }
}

