/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.bc.issue.vote.VoteService;
import com.atlassian.jira.bc.issue.watcher.WatcherService;
import com.atlassian.jira.bc.issue.worklog.TimeTrackingConfiguration;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.AttachmentConfigManager;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.rest.v2.admin.ConfigurationBean;
import com.atlassian.jira.rest.v2.admin.TimeTrackingConfigurationBean;
import io.atlassian.fugue.Option;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationBeanFactory {
    private final VoteService voteService;
    private final WatcherService watcherService;
    private final ApplicationProperties applicationProperties;
    private final SubTaskManager subTaskManager;
    private final AttachmentConfigManager attachmentConfigManager;
    private final IssueLinkManager issueLinkManager;
    private final TimeTrackingConfiguration timeTrackingConfiguration;

    @Autowired
    public ConfigurationBeanFactory(VoteService voteService, WatcherService watcherService, ApplicationProperties applicationProperties, SubTaskManager subTaskManager, AttachmentConfigManager attachmentConfigManager, IssueLinkManager issueLinkManager, TimeTrackingConfiguration timeTrackingConfiguration) {
        this.voteService = voteService;
        this.watcherService = watcherService;
        this.applicationProperties = applicationProperties;
        this.subTaskManager = subTaskManager;
        this.attachmentConfigManager = Objects.requireNonNull(attachmentConfigManager);
        this.issueLinkManager = issueLinkManager;
        this.timeTrackingConfiguration = timeTrackingConfiguration;
    }

    public ConfigurationBean createConfigurationBean() {
        boolean timeTrackingEnabled = this.timeTrackingConfiguration.enabled();
        if (timeTrackingEnabled) {
            return this.createConfigurationBean(true, (Option<TimeTrackingConfigurationBean>)Option.some((Object)this.createTimeTrackingConfiguration()));
        }
        return this.createConfigurationBean(false, (Option<TimeTrackingConfigurationBean>)Option.none(TimeTrackingConfigurationBean.class));
    }

    private ConfigurationBean createConfigurationBean(boolean timeTrackingEnabled, Option<TimeTrackingConfigurationBean> timeTrackingConfigurationBean) {
        return ConfigurationBean.builer().votingEnabled(this.voteService.isVotingEnabled()).watchingEnabled(this.watcherService.isWatchingEnabled()).unassignedIssuesAllowed(this.applicationProperties.getOption("jira.option.allowunassigned")).subTasksEnabled(this.subTaskManager.isSubTasksEnabled()).attachmentsEnabled(this.attachmentConfigManager.isAttachmentsEnabled()).issueLinkingEnabled(this.issueLinkManager.isLinkingEnabled()).timeTrackingEnabled(timeTrackingEnabled).timeTrackingConfiguration((TimeTrackingConfigurationBean)timeTrackingConfigurationBean.getOrNull()).build();
    }

    private TimeTrackingConfigurationBean createTimeTrackingConfiguration() {
        double hoursPerDay = this.timeTrackingConfiguration.getHoursPerDay().doubleValue();
        double daysPerWeek = this.timeTrackingConfiguration.getDaysPerWeek().doubleValue();
        TimeTrackingConfiguration.TimeFormat timeFormat = this.timeTrackingConfiguration.getTimeFormat();
        TimeTrackingConfigurationBean.TimeTrackingUnit timeTrackingUnit = this.getTimeTrackingUnit();
        return new TimeTrackingConfigurationBean(hoursPerDay, daysPerWeek, timeFormat, timeTrackingUnit);
    }

    private TimeTrackingConfigurationBean.TimeTrackingUnit getTimeTrackingUnit() {
        DateUtils.Duration unit = this.timeTrackingConfiguration.getDefaultUnit();
        switch (unit) {
            case HOUR: {
                return TimeTrackingConfigurationBean.TimeTrackingUnit.hour;
            }
            case DAY: {
                return TimeTrackingConfigurationBean.TimeTrackingUnit.day;
            }
            case WEEK: {
                return TimeTrackingConfigurationBean.TimeTrackingUnit.week;
            }
        }
        return TimeTrackingConfigurationBean.TimeTrackingUnit.minute;
    }
}

