/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.bc.admin.ApplicationPropertiesService;
import com.atlassian.jira.bc.admin.ApplicationProperty;
import com.atlassian.jira.bc.admin.ApplicationPropertyMetadata;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.rest.v2.admin.ApplicationPropertyBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.validation.Validated;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="application-properties")
@Produces(value={"application/json"})
@WebSudoRequired
@AdminOnly
public class ApplicationPropertiesResource {
    private static final Logger log = LoggerFactory.getLogger(ApplicationPropertiesResource.class);
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;
    private final ApplicationPropertiesService applicationPropertiesService;
    private static final String DOC_EXAMPLE_LIST = "[\n    {\n        \"id\": \"jira.home\",\n        \"key\": \"jira.home\",\n        \"value\": \"/var/jira/jira-home\",\n        \"name\": \"jira.home\",\n        \"desc\": \"Jira home directory\",\n        \"type\": \"string\",\n        \"defaultValue\": \"\"\n    },\n    {\n        \"id\": \"jira.clone.prefix\",\n        \"key\": \"jira.clone.prefix\",\n        \"value\": \"CLONE -\",\n        \"name\": \"The prefix added to the Summary field of cloned issues\",\n        \"type\": \"string\",\n        \"defaultValue\": \"CLONE -\"\n    }\n]";

    @Inject
    public ApplicationPropertiesResource(JiraAuthenticationContext authenticationContext, PermissionManager permissionManager, ApplicationPropertiesService applicationPropertiesService) {
        this.authenticationContext = (JiraAuthenticationContext)Assertions.notNull((String)"authenticationContext", (Object)authenticationContext);
        this.permissionManager = (PermissionManager)Assertions.notNull((String)"permissionManager", (Object)permissionManager);
        this.applicationPropertiesService = (ApplicationPropertiesService)Assertions.notNull((String)"applicationPropertiesService", (Object)applicationPropertiesService);
    }

    @GET
    @Operation(summary="Get an application property by key", description="Returns an application property.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="key", description="a String containing the property key.", in=ParameterIn.QUERY, required=true), @Parameter(name="permissionLevel", description="when fetching a list specifies the permission level of all items in the list\nsee {@link com.atlassian.jira.bc.admin.ApplicationPropertiesService.EditPermissionLevel}", in=ParameterIn.QUERY, required=true), @Parameter(name="keyFilter", description="when fetching a list allows the list to be filtered by the property's start of key\ne.g. \"jira.lf.*\" whould fetch only those permissions that are editable and whose keys start with\n     *                        \"jira.lf.\". This is a regex.", in=ParameterIn.QUERY)})
    @ApiResponses(value={@ApiResponse(description="Returned if the property exists and the currently authenticated user has permission to view it. Contains a full representation of the property.", responseCode="200", content={@Content(schema=@Schema(implementation=Property.class), mediaType="application/json", examples={@ExampleObject(name="example", value="[\n    {\n        \"id\": \"jira.home\",\n        \"key\": \"jira.home\",\n        \"value\": \"/var/jira/jira-home\",\n        \"name\": \"jira.home\",\n        \"desc\": \"Jira home directory\",\n        \"type\": \"string\",\n        \"defaultValue\": \"\"\n    },\n    {\n        \"id\": \"jira.clone.prefix\",\n        \"key\": \"jira.clone.prefix\",\n        \"value\": \"CLONE -\",\n        \"name\": \"The prefix added to the Summary field of cloned issues\",\n        \"type\": \"string\",\n        \"defaultValue\": \"CLONE -\"\n    }\n]")})}), @ApiResponse(description="The action performed requires a logged in user.", responseCode="403"), @ApiResponse(description="Returned if the currently authenticated user does not have permission to view it.", responseCode="404")})
    public Response getProperty(@QueryParam(value="key") String key, @QueryParam(value="permissionLevel") String permissionLevel, @QueryParam(value="keyFilter") String keyFilter) {
        if (key != null) {
            ApplicationProperty property;
            if (log.isDebugEnabled()) {
                log.debug("Got request for property value with key " + key);
            }
            if (this.hasPermissionToEdit(property = this.applicationPropertiesService.getApplicationProperty(key))) {
                return Response.ok((Object)new Property(property, this.authenticationContext.getI18nHelper())).cacheControl(CacheControl.NO_CACHE).build();
            }
            log.debug("No permission to get property: " + key);
            return this.noPermissionResponse();
        }
        if (this.applicationPropertiesService.hasPermissionForLevel(permissionLevel)) {
            log.debug("Got request for all editable property values");
            List editableApplicationProperties = this.applicationPropertiesService.getEditableApplicationProperties(permissionLevel, keyFilter);
            ArrayList<Property> props = new ArrayList<Property>(editableApplicationProperties.size());
            for (ApplicationProperty editableApplicationProperty : editableApplicationProperties) {
                props.add(new Property(editableApplicationProperty, this.authenticationContext.getI18nHelper()));
            }
            return Response.ok(props).cacheControl(CacheControl.NO_CACHE).build();
        }
        log.debug("No permission to get properties.");
        return this.noPermissionResponse();
    }

    @Path(value="advanced-settings")
    @GET
    @Operation(summary="Get all advanced settings properties", description="Returns the properties that are displayed on the \"General Configuration > Advanced Settings\" page.", security={@SecurityRequirement(name="basic")})
    @ApiResponses(value={@ApiResponse(description="Returns all properties to display in the \"General Configuration > Advanced Settings\" page.", responseCode="200", content={@Content(schema=@Schema(implementation=Property.class), mediaType="application/json", examples={@ExampleObject(name="example", value="[\n    {\n        \"id\": \"jira.home\",\n        \"key\": \"jira.home\",\n        \"value\": \"/var/jira/jira-home\",\n        \"name\": \"jira.home\",\n        \"desc\": \"Jira home directory\",\n        \"type\": \"string\",\n        \"defaultValue\": \"\"\n    },\n    {\n        \"id\": \"jira.clone.prefix\",\n        \"key\": \"jira.clone.prefix\",\n        \"value\": \"CLONE -\",\n        \"name\": \"The prefix added to the Summary field of cloned issues\",\n        \"type\": \"string\",\n        \"defaultValue\": \"CLONE -\"\n    }\n]")})}), @ApiResponse(description="Returned if the current user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the current user is not an administrator.", responseCode="403")})
    public Response getAdvancedSettings() {
        if (this.applicationPropertiesService.hasAdministrativePermissions()) {
            log.debug("Got request for all editable advanced property values");
            List editableAdvancedProperties = this.applicationPropertiesService.getEditableAdvancedProperties();
            List props = editableAdvancedProperties.stream().map(p -> new Property((ApplicationProperty)p, this.authenticationContext.getI18nHelper())).collect(Collectors.toList());
            return Response.ok(props).cacheControl(CacheControl.NO_CACHE).build();
        }
        if (this.authenticationContext.isLoggedInUser()) {
            log.debug("No permission to get the advanced properties.");
            return this.noPermissionResponse();
        }
        log.debug("No authentication to get the advanced properties.");
        return this.noAuthenticationResponse();
    }

    @PUT
    @Path(value="{id}")
    @Operation(summary="Update an application property", description="Update an application property via PUT. The \"value\" field present in the PUT will override the existing value.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="id", description="a String containing the property key.", in=ParameterIn.PATH, required=true), @Parameter(name="applicationPropertyBean", description="new contents of an application property.", in=ParameterIn.DEFAULT, required=true, schema=@Schema(implementation=ApplicationPropertyBean.class))})
    @ApiResponses(value={@ApiResponse(description="Returned if the property exists and the currently authenticated user has permission to edit it.", responseCode="200", content={@Content(schema=@Schema(implementation=Property.class), mediaType="application/json")}), @ApiResponse(description="Returned if the currently authenticated user does not have permission to edit the property.", responseCode="403"), @ApiResponse(description="Returned if the property does not exist or the currently authenticated user does not have permission to view it.", responseCode="404")})
    public Response setPropertyViaRestfulTable(@PathParam(value="id") String key, @RequestBody ApplicationPropertyBean applicationPropertyBean) {
        String value = applicationPropertyBean.getValue();
        return this.setProperty(key, value);
    }

    private boolean hasPermissionToEdit(ApplicationProperty applicationProperty) {
        if (applicationProperty.getMetadata().isAdminEditable()) {
            return this.permissionManager.hasPermission(0, this.authenticationContext.getUser()) || this.permissionManager.hasPermission(44, this.authenticationContext.getUser());
        }
        if (applicationProperty.getMetadata().isSysadminEditable()) {
            return this.permissionManager.hasPermission(44, this.authenticationContext.getUser());
        }
        return false;
    }

    public Response setProperty(String key, String value) {
        if (key != null) {
            ApplicationProperty property = this.applicationPropertiesService.getApplicationProperty(key);
            if (!this.hasPermissionToEdit(property)) {
                log.debug("No permission to set a property: " + key);
                return this.noPermissionResponse();
            }
            try {
                Validated validatedApplicationProperty = this.applicationPropertiesService.setApplicationProperty(key, value);
                if (validatedApplicationProperty.getResult().isValid()) {
                    return Response.ok((Object)new Property((ApplicationProperty)validatedApplicationProperty.getValue(), this.authenticationContext.getI18nHelper())).cacheControl(CacheControl.NO_CACHE).build();
                }
                SimpleErrorCollection simpleErrorCollection = new SimpleErrorCollection();
                simpleErrorCollection.addError("value", validatedApplicationProperty.getResult().getErrorMessage());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)simpleErrorCollection)).cacheControl(CacheControl.NO_CACHE).build();
            }
            catch (Exception e) {
                log.info("Error setting Application Property", (Throwable)e);
                return Response.serverError().cacheControl(CacheControl.NO_CACHE).build();
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of("No property key passed with the request!")).cacheControl(CacheControl.NO_CACHE).build();
    }

    private Response noAuthenticationResponse() {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)ErrorCollection.of("No authentication to access this resource")).cacheControl(CacheControl.NO_CACHE).build();
    }

    private Response noPermissionResponse() {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ErrorCollection.of("No permission")).cacheControl(CacheControl.NO_CACHE).build();
    }

    @XmlRootElement
    public static class Property {
        @XmlElement
        private String id;
        @XmlElement
        private String key;
        @XmlElement
        private String value;
        @XmlElement
        private String name;
        @XmlElement
        private String desc;
        @XmlElement
        private String type;
        @XmlElement
        private String defaultValue;
        @XmlElement
        private String example;
        @XmlElement
        private Collection<String> allowedValues;

        private Property() {
        }

        public Property(ApplicationProperty applicationProperty) {
            this(applicationProperty, null);
        }

        public Property(ApplicationProperty applicationProperty, I18nHelper i18n) {
            ApplicationPropertyMetadata metadata = applicationProperty.getMetadata();
            this.id = metadata.getKey();
            this.key = metadata.getKey();
            this.value = applicationProperty.getCurrentValue();
            this.name = Property.getName(metadata, i18n);
            this.desc = Property.getDescription(metadata, i18n);
            this.type = metadata.getType();
            if (!metadata.getDefaultValue().equals(this.value)) {
                this.defaultValue = metadata.getDefaultValue();
            }
            if (metadata.getType().equals("enum")) {
                this.allowedValues = metadata.getEnumerator().getEnumeration();
            }
            if (metadata.getExampleGenerator() != null) {
                this.example = metadata.getExampleGenerator().generate((Object)this.value);
            }
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "Property{key='" + this.key + "', value='" + this.value + "', name='" + this.name + "', desc='" + this.desc + "', type='" + this.type + "', defaultValue='" + this.defaultValue + "'}";
        }

        private static String getName(ApplicationPropertyMetadata metadata, I18nHelper i18n) {
            if (i18n != null && !StringUtils.isBlank((CharSequence)metadata.getNameKey())) {
                return i18n.getText(metadata.getNameKey());
            }
            return metadata.getName();
        }

        private static String getDescription(ApplicationPropertyMetadata metadata, I18nHelper i18n) {
            if (i18n != null && !StringUtils.isBlank((CharSequence)metadata.getDescriptionKey())) {
                return i18n.getText(metadata.getDescriptionKey());
            }
            return metadata.getDescription();
        }

        public String getExample() {
            return this.example;
        }
    }
}

