/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.v2.ServerInfoBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.AccessDisablingHelper;
import com.atlassian.jira.util.AccessDisablingHelperConfig;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.api.security.annotation.CorsAllowed;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.Date;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="serverInfo")
@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@CorsAllowed
public class ServerInfoResource {
    private final ApplicationProperties properties;
    private final BuildUtilsInfo buildUtils;
    private final JiraAuthenticationContext authContext;
    private final PermissionManager permissionManager;
    private final AccessDisablingHelper accessDisablingHelper;

    @Inject
    public ServerInfoResource(ApplicationProperties properties, BuildUtilsInfo buildUtils, JiraAuthenticationContext authContext, PermissionManager permissionManager, AccessDisablingHelper accessDisablingHelper) {
        this.properties = properties;
        this.buildUtils = buildUtils;
        this.authContext = authContext;
        this.permissionManager = permissionManager;
        this.accessDisablingHelper = accessDisablingHelper;
    }

    @GET
    @Operation(summary="Get general information about the current Jira server", description="Returns general information about the current Jira server.", security={@SecurityRequirement(name="basic")})
    @ApiResponse(description="Returns a full representation of the server info in JSON format.", responseCode="200", content={@Content(schema=@Schema(implementation=ServerInfoBean.class), mediaType="application/json")})
    public ServerInfoBean getServerInfo() {
        this.blockAnonymousUsersIfNeeded();
        boolean canUse = this.permissionManager.hasPermission(1, this.authContext.getUser());
        return new ServerInfoBean(this.properties.getString("jira.baseurl"), this.buildUtils.getVersion(), this.buildUtils.getVersionNumbers(), Integer.valueOf(this.buildUtils.getCurrentBuildNumber()), this.buildUtils.getCurrentBuildDate(), this.buildUtils.getDatabaseBuildNumber(), this.buildUtils.getCommitId(), this.buildUtils.getBuildPartnerName(), this.properties.getString("jira.title"), canUse ? new Date() : null);
    }

    private void blockAnonymousUsersIfNeeded() {
        AccessDisablingHelperConfig accessConfig = AccessDisablingHelperConfig.builder().blockAnyoneNotFulfillingCondition(this::canUserAccess).build();
        if (!this.accessDisablingHelper.canBeAccessedByCurrentUser(accessConfig)) {
            throw new NotAuthorisedWebException();
        }
    }

    private boolean canUserAccess(ApplicationUser user) {
        return user != null || this.permissionManager.hasProjects(ProjectPermissions.BROWSE_PROJECTS, null);
    }
}

