/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v1.users;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.user.search.UserSearchIssueContext;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.bc.user.search.UserSearchUtilities;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigManager;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserFilter;
import com.atlassian.jira.user.UserFilterManager;
import com.atlassian.jira.util.DelimeterInserter;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.google.common.collect.Sets;
import com.opensymphony.util.TextUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Path(value="users/picker")
@AnonymousSiteAccess
@Produces(value={"application/json", "application/xml"})
public class UserPickerResource {
    private static final Logger log = LoggerFactory.getLogger(UserPickerResource.class);
    private final JiraAuthenticationContext authContext;
    private final UserSearchService service;
    private final ApplicationProperties applicationProperties;
    private final AvatarService avatarService;
    private final I18nHelper i18nHelper;
    private final UserFilterManager userFilterManager;
    private final FieldConfigManager fieldConfigManager;
    private final IssueManager issueManager;
    private final FeatureManager featureManager;
    private final UserSearchService userSearchService;

    @Inject
    public UserPickerResource(JiraAuthenticationContext authContext, I18nHelper i18nHelper, UserSearchService service, ApplicationProperties applicationProperties, AvatarService avatarService, UserFilterManager userFilterManager, FieldConfigManager fieldConfigManager, IssueManager issueManager, FeatureManager featureManager, UserSearchService userSearchService) {
        this.authContext = authContext;
        this.service = service;
        this.applicationProperties = applicationProperties;
        this.avatarService = avatarService;
        this.i18nHelper = i18nHelper;
        this.userFilterManager = userFilterManager;
        this.fieldConfigManager = fieldConfigManager;
        this.issueManager = issueManager;
        this.featureManager = featureManager;
        this.userSearchService = userSearchService;
    }

    @GET
    public Response getUsersResponse(@QueryParam(value="fieldName") String fieldName, @QueryParam(value="fieldConfigId") String fieldConfigId, @QueryParam(value="projectId") List<String> projectIdList, @QueryParam(value="query") String query, @QueryParam(value="showAvatar") boolean showAvatar, @QueryParam(value="exclude") List<String> excludeUsers) {
        return Response.ok((Object)this.getUsers(fieldName, fieldConfigId, projectIdList, query, showAvatar, excludeUsers)).cacheControl(CacheControl.NO_CACHE).build();
    }

    @GET
    @Path(value="/filter")
    public Response getFilteredUsersResponse(@QueryParam(value="fieldName") String fieldName, @QueryParam(value="fieldConfigId") String fieldConfigId, @QueryParam(value="projectId") List<String> projectIdList, @QueryParam(value="query") String query, @QueryParam(value="showAvatar") boolean showAvatar, @QueryParam(value="exclude") List<String> excludeUsers, @QueryParam(value="issueKey") String issueKey) {
        if (!this.featureManager.isEnabled(JiraFeatureFlagRegistrar.FILTER_USERS_WITHOUT_PROJECT_ACCESS_IN_WATCHER_PICKER)) {
            return Response.ok((Object)this.getUsers(fieldName, fieldConfigId, projectIdList, query, showAvatar, excludeUsers)).cacheControl(CacheControl.NO_CACHE).build();
        }
        if (excludeUsers == null) {
            excludeUsers = new ArrayList<String>();
        }
        JiraServiceContext jiraServiceContext = this.getContext();
        UserPickerResultsWrapper results = new UserPickerResultsWrapper();
        MutableIssue issue = this.issueManager.getIssueObject(issueKey);
        UserSearchIssueContext userSearchIssueContext = UserSearchIssueContext.create((Issue)issue);
        boolean canShowEmailAddresses = this.service.canShowEmailAddresses(jiraServiceContext);
        List users = this.userSearchService.findTopWatcherUsers(query, userSearchIssueContext, this.getLimit());
        int total = users.size();
        results.setTotal(total);
        for (ApplicationUser user : users) {
            if (excludeUsers.contains(user.getName())) continue;
            String html = this.formatUser(fieldName, user, query, canShowEmailAddresses);
            results.addUser(new UserPickerUser(user.getName(), user.getDisplayName(), html, showAvatar ? this.avatarService.getAvatarURL(user, user.getName(), Avatar.Size.SMALL) : null));
        }
        return Response.ok((Object)results).cacheControl(CacheControl.NO_CACHE).build();
    }

    UserPickerResultsWrapper getUsers(String fieldName, String fieldConfigId, List<String> projectIdList, String query, boolean showAvatar, List<String> excludeUsers) {
        boolean isCustomField;
        JiraServiceContext jiraServiceCtx = this.getContext();
        UserPickerResultsWrapper results = new UserPickerResultsWrapper();
        if (excludeUsers == null) {
            excludeUsers = new ArrayList<String>();
        }
        if (!this.service.canPerformAjaxSearch(jiraServiceCtx)) {
            return results;
        }
        boolean canShowEmailAddresses = this.service.canShowEmailAddresses(jiraServiceCtx);
        UserSearchParams.Builder paramBuilder = UserSearchParams.builder().allowEmptyQuery(false).includeActive(true).includeInactive(false);
        boolean bl = isCustomField = fieldName != null && fieldName.startsWith("customfield_");
        if (isCustomField && fieldConfigId != null) {
            UserFilter filter = this.getUserFilter(fieldConfigId, fieldName);
            if (filter == null) {
                return results;
            }
            paramBuilder.filter(filter).filterByProjectIds(this.getProjectIdSet(projectIdList));
        }
        List users = this.service.findUsers(jiraServiceCtx, query, paramBuilder.build());
        int limit = this.getLimit();
        int count = 0;
        int total = users.size();
        for (ApplicationUser user : users) {
            if (!excludeUsers.contains(user.getName())) {
                String html = this.formatUser(fieldName, user, query, canShowEmailAddresses);
                results.addUser(new UserPickerUser(user.getName(), user.getDisplayName(), html, showAvatar ? this.avatarService.getAvatarURL(user, user.getName(), Avatar.Size.SMALL) : null));
                ++count;
            } else {
                --total;
            }
            if (count < limit) continue;
            break;
        }
        results.setTotal(total);
        results.setFooter(this.i18nHelper.getText("jira.ajax.autocomplete.user.more.results", String.valueOf(count), String.valueOf(total)));
        return results;
    }

    private UserFilter getUserFilter(String fieldConfigId, String fieldName) {
        FieldConfig fieldConfig = this.getFieldConfig(fieldConfigId, fieldName);
        if (fieldConfig == null) {
            return null;
        }
        return this.userFilterManager.getFilter(fieldConfig);
    }

    private FieldConfig getFieldConfig(String fieldConfigId, String fieldName) {
        block3: {
            try {
                FieldConfig fieldConfig;
                if (!StringUtils.isNotBlank((CharSequence)fieldConfigId) || (fieldConfig = this.fieldConfigManager.getFieldConfig(Long.valueOf(fieldConfigId))) == null) break block3;
                CustomField customField = fieldConfig.getCustomField();
                if (customField == null || !fieldName.equals(customField.getId())) {
                    log.warn("invalid parameters to /1/users/picker: fieldName " + fieldName + " does not match field config id " + fieldConfigId);
                    break block3;
                }
                return fieldConfig;
            }
            catch (NumberFormatException nfe) {
                log.warn("Incorrect fieldConfigId '" + fieldConfigId + "' to /1/users/picker. Expecting a numeric id.");
            }
        }
        return null;
    }

    private Set<Long> getProjectIdSet(List<String> projectIdList) {
        HashSet projectIds = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            for (String projectIdStr : projectIdList) {
                try {
                    long projectId = Long.valueOf(projectIdStr);
                    if (projectId <= 0L) continue;
                    projectIds.add(projectId);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return projectIds;
    }

    private String getElementId(String fieldName, String type, String field) {
        return " id=\"" + fieldName + "_" + type + "_" + field + "\" ";
    }

    private int getLimit() {
        int limit = 20;
        try {
            limit = Integer.valueOf(this.applicationProperties.getDefaultBackedString("jira.ajax.autocomplete.limit"));
        }
        catch (Exception nfe) {
            log.error("jira.ajax.autocomplete.limit does not exist or is an invalid number in jira-application.properties. Using default value 20.", (Throwable)nfe);
        }
        return limit;
    }

    private String formatUser(String fieldName, ApplicationUser user, String query, boolean canShoweEmailAddresses) {
        DelimeterInserter delimeterInserter = new DelimeterInserter("<b>", "</b>");
        delimeterInserter.setConsideredWhitespace(UserSearchUtilities.SEPARATORS_STRING);
        String[] terms = new String[]{query};
        String userFullName = delimeterInserter.insert(TextUtils.htmlEncode((String)user.getDisplayName()), terms);
        String userName = delimeterInserter.insert(TextUtils.htmlEncode((String)user.getName()), terms);
        StringBuilder sb = new StringBuilder();
        sb.append("<div ");
        if (!StringUtils.isEmpty((CharSequence)fieldName)) {
            sb.append(this.getElementId(fieldName, "i", TextUtils.htmlEncode((String)user.getName())));
        }
        sb.append("class=\"yad\" ");
        sb.append(">");
        sb.append(userFullName);
        if (canShoweEmailAddresses) {
            String userEmail = delimeterInserter.insert(TextUtils.htmlEncode((String)user.getEmailAddress()), terms);
            sb.append("&nbsp;-&nbsp;");
            sb.append(userEmail);
        }
        sb.append("&nbsp;(");
        sb.append(userName);
        sb.append(")");
        sb.append("</div>");
        return sb.toString();
    }

    JiraServiceContext getContext() {
        ApplicationUser user = this.authContext.getUser();
        return new JiraServiceContextImpl(user);
    }

    @XmlRootElement
    public static class UserPickerResultsWrapper {
        @XmlElement
        private List<UserPickerUser> users;
        @XmlElement
        private Integer total;
        @XmlElement
        private String footer;

        private UserPickerResultsWrapper() {
        }

        public UserPickerResultsWrapper(List<UserPickerUser> users, String footer, Integer total) {
            this.users = users;
            this.footer = footer;
            this.total = total;
        }

        public void addUser(UserPickerUser user) {
            if (this.users == null) {
                this.users = new ArrayList<UserPickerUser>();
            }
            this.users.add(user);
        }

        public void setFooter(String footer) {
            this.footer = footer;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public String toString() {
            return "UserPickerResultsWrapper{users=" + this.users + ", total=" + this.total + ", footer='" + this.footer + "'}";
        }
    }

    @XmlRootElement
    public static class UserPickerUser {
        @XmlElement
        private String name;
        @XmlElement
        private String html;
        @XmlElement
        private String displayName;
        @XmlElement
        private URI avatarUrl;

        private UserPickerUser() {
        }

        public UserPickerUser(String name, String displayName, String html, URI avatarUrl) {
            this.name = name;
            this.displayName = displayName;
            this.html = html;
            this.avatarUrl = avatarUrl;
        }

        public String toString() {
            return "UserPickerUser{name='" + this.name + "', html='" + this.html + "', displayName='" + this.displayName + "', avatarUrl=" + this.avatarUrl + "}";
        }
    }
}

