/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v1.jql;

import com.atlassian.jira.rest.internal.jql.FieldAndPredicateAutoCompleteResultGenerator;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.api.security.annotation.CorsAllowed;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="jql/autocomplete")
@AnonymousSiteAccess
@Produces(value={"application/json", "application/xml"})
@CorsAllowed
public class AutoCompleteResource {
    private final FieldAndPredicateAutoCompleteResultGenerator fieldAndPredicateAutoCompleteResultGenerator;

    @Inject
    public AutoCompleteResource(FieldAndPredicateAutoCompleteResultGenerator fieldAndPredicateAutoCompleteResultGenerator) {
        this.fieldAndPredicateAutoCompleteResultGenerator = fieldAndPredicateAutoCompleteResultGenerator;
    }

    @GET
    public Response getIssuesResponse(@QueryParam(value="fieldName") String fieldName, @QueryParam(value="fieldValue") String fieldValue, @QueryParam(value="predicateName") String predicateName, @QueryParam(value="predicateValue") String predicateValue) {
        ImmutableList.Builder results = ImmutableList.builder();
        if (fieldValue != null) {
            results.addAll(this.fieldAndPredicateAutoCompleteResultGenerator.getAutoCompleteResultsForField(fieldName, fieldValue));
        }
        if (predicateName != null) {
            results.addAll(this.fieldAndPredicateAutoCompleteResultGenerator.getAutoCompleteResultsForPredicate(predicateName, predicateValue, fieldName));
        }
        return Response.ok((Object)AutoCompleteResultsBean.wrap((ImmutableList<FieldAndPredicateAutoCompleteResultGenerator.Result>)results.build())).cacheControl(CacheControl.NO_CACHE).build();
    }

    @XmlRootElement(name="autoCompleteResultWrapper")
    public static class AutoCompleteResultsBean {
        @XmlElement
        private List<AutoCompleteResultBean> results;

        public AutoCompleteResultsBean() {
            this(Lists.newArrayList());
        }

        public AutoCompleteResultsBean(Iterable<AutoCompleteResultBean> results) {
            this.results = ImmutableList.copyOf(results);
        }

        public static AutoCompleteResultsBean wrap(ImmutableList<FieldAndPredicateAutoCompleteResultGenerator.Result> results) {
            return new AutoCompleteResultsBean(Iterables.transform(results, (Function)new Function<FieldAndPredicateAutoCompleteResultGenerator.Result, AutoCompleteResultBean>(){

                public AutoCompleteResultBean apply(FieldAndPredicateAutoCompleteResultGenerator.Result result) {
                    return new AutoCompleteResultBean(result.getValue(), result.getDisplayName());
                }
            }));
        }
    }

    @XmlRootElement
    public static class AutoCompleteResultBean {
        @XmlElement
        private String value;
        @XmlElement
        private String displayName;

        public AutoCompleteResultBean() {
        }

        public AutoCompleteResultBean(String value, String displayName) {
            this.value = value;
            this.displayName = displayName;
        }
    }
}

