/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v1.issues;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.vote.VoteService;
import com.atlassian.jira.event.mau.MauEventService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.rest.util.IssuePicker;
import com.atlassian.jira.rest.v1.issues.IssueActionsAndOperationsResource;
import com.atlassian.jira.rest.v1.issues.IssuePickerResource;
import com.atlassian.jira.rest.v1.model.errors.ErrorCollection;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.IssueWorkflowManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="issues")
@AnonymousSiteAccess
@Consumes(value={"application/json", "application/xml"})
@Produces(value={"application/json", "application/xml"})
public class IssueResource {
    private final JiraAuthenticationContext authContext;
    private final I18nHelper i18n;
    private final IssueManager issueManager;
    private final IssueService issueService;
    private final SimpleLinkManager simpleLinkManager;
    private final XsrfTokenGenerator xsrfTokenGenerator;
    private final VoteService voteService;
    private final WatcherManager watcherManager;
    private final IssueWorkflowManager issueWorkflowManager;
    private final IssuePicker issuePicker;
    private final MauEventService mauEventService;

    @Inject
    public IssueResource(JiraAuthenticationContext authContext, I18nHelper i18n, IssueManager issueManager, IssueService issueService, SimpleLinkManager simpleLinkManager, XsrfTokenGenerator xsrfTokenGenerator, VoteService voteService, WatcherManager watcherManager, IssueWorkflowManager issueWorkflowManager, IssuePicker issuePicker, @ComponentImport MauEventService mauEventService) {
        this.authContext = authContext;
        this.i18n = i18n;
        this.issueManager = issueManager;
        this.issueService = issueService;
        this.simpleLinkManager = simpleLinkManager;
        this.xsrfTokenGenerator = xsrfTokenGenerator;
        this.voteService = voteService;
        this.watcherManager = watcherManager;
        this.issueWorkflowManager = issueWorkflowManager;
        this.issuePicker = issuePicker;
        this.mauEventService = mauEventService;
    }

    @Path(value="picker")
    public IssuePickerResource getIssuePickerResource() {
        return new IssuePickerResource(this.issuePicker);
    }

    @Path(value="{issueId}/ActionsAndOperations")
    public IssueActionsAndOperationsResource getActionsAndOperationsResource(@PathParam(value="issueId") String issueId) {
        return new IssueActionsAndOperationsResource(this.authContext, this.issueService, this.i18n, issueId, this.simpleLinkManager, this.xsrfTokenGenerator, this.issueWorkflowManager);
    }

    @POST
    @Path(value="{issueId}/voters")
    @Operation(description="Adds voter (currently logged user) to particular ticket. You need to be logged in to use this method.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="issueId", description="Issue id.", in=ParameterIn.PATH)
    @ApiResponses(value={@ApiResponse(description="Returns the vote count for particular ticket.", responseCode="200", content={@Content(schema=@Schema(implementation=VoteWatchResult.class), mediaType="application/json")}), @ApiResponse(description="The action performed requires a logged in user.", responseCode="401"), @ApiResponse(description="Issue with given id was not found.", responseCode="404"), @ApiResponse(description="Returned if the HTTP request call is invalid.", responseCode="400", content={@Content(schema=@Schema(implementation=ErrorCollection.class), mediaType="application/json")})})
    public Response addVoter(@PathParam(value="issueId") Long issueId) {
        ApplicationUser user = this.authContext.getUser();
        if (this.notAuthenticatedRequest(user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(CacheControl.NO_CACHE).build();
        }
        IssueService.IssueResult result = this.issueService.getIssue(user, issueId);
        if (result.getIssue() == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.NO_CACHE).build();
        }
        this.tagRESTRequestForMauTrackingPurposes((Issue)result.getIssue());
        VoteService.VoteValidationResult validationResult = this.voteService.validateAddVote(user, user, (Issue)result.getIssue());
        if (validationResult.isValid()) {
            int votes = this.voteService.addVote(user, validationResult);
            return Response.ok((Object)new VoteWatchResult(votes)).cacheControl(CacheControl.NO_CACHE).build();
        }
        ErrorCollection errors = ErrorCollection.Builder.newBuilder().addErrorCollection(validationResult.getErrorCollection()).build();
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errors).cacheControl(CacheControl.NO_CACHE).build();
    }

    @DELETE
    @Path(value="{issueId}/voters")
    public Response removeVoter(@PathParam(value="issueId") Long issueId) {
        ApplicationUser user = this.authContext.getUser();
        if (this.notAuthenticatedRequest(user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(CacheControl.NO_CACHE).build();
        }
        IssueService.IssueResult result = this.issueService.getIssue(user, issueId);
        if (result.getIssue() == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.NO_CACHE).build();
        }
        this.tagRESTRequestForMauTrackingPurposes((Issue)result.getIssue());
        VoteService.VoteValidationResult validationResult = this.voteService.validateRemoveVote(user, user, (Issue)result.getIssue());
        if (validationResult.isValid()) {
            int votes = this.voteService.removeVote(user, validationResult);
            return Response.ok((Object)new VoteWatchResult(votes)).cacheControl(CacheControl.NO_CACHE).build();
        }
        ErrorCollection errors = ErrorCollection.Builder.newBuilder().addErrorCollection(validationResult.getErrorCollection()).build();
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errors).cacheControl(CacheControl.NO_CACHE).build();
    }

    @POST
    @Path(value="{issueId}/watchers")
    public Response addWatcher(@PathParam(value="issueId") Long issueId) {
        ApplicationUser user = this.authContext.getUser();
        if (this.notAuthenticatedRequest(user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(CacheControl.NO_CACHE).build();
        }
        IssueService.IssueResult result = this.issueService.getIssue(user, issueId);
        if (result.getIssue() == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.NO_CACHE).build();
        }
        this.tagRESTRequestForMauTrackingPurposes((Issue)result.getIssue());
        if (!this.watcherManager.isWatchingEnabled() || this.notAuthenticatedRequest(user)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.NO_CACHE).build();
        }
        this.watcherManager.startWatching(user, (Issue)result.getIssue());
        int watcherCount = this.watcherManager.getWatcherCount((Issue)result.getIssue());
        return Response.ok((Object)new VoteWatchResult(watcherCount)).cacheControl(CacheControl.NO_CACHE).build();
    }

    @DELETE
    @Path(value="{issueId}/watchers")
    public Response removeWatcher(@PathParam(value="issueId") Long issueId) {
        ApplicationUser user = this.authContext.getUser();
        if (this.notAuthenticatedRequest(user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(CacheControl.NO_CACHE).build();
        }
        IssueService.IssueResult result = this.issueService.getIssue(user, issueId);
        if (result.getIssue() == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.NO_CACHE).build();
        }
        this.tagRESTRequestForMauTrackingPurposes((Issue)result.getIssue());
        if (!this.watcherManager.isWatchingEnabled()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.NO_CACHE).build();
        }
        this.watcherManager.stopWatching(user, (Issue)result.getIssue());
        int watcherCount = this.watcherManager.getWatcherCount((Issue)result.getIssue());
        return Response.ok((Object)new VoteWatchResult(watcherCount)).cacheControl(CacheControl.NO_CACHE).build();
    }

    private boolean notAuthenticatedRequest(ApplicationUser user) {
        return user == null;
    }

    private void tagRESTRequestForMauTrackingPurposes(Issue issue) {
        this.mauEventService.setApplicationForThreadBasedOnProject(issue.getProjectObject());
    }

    @XmlRootElement
    public static class VoteWatchResult {
        @XmlElement
        private int count = 0;

        private VoteWatchResult() {
        }

        public VoteWatchResult(int count) {
            this.count = count;
        }

        public int voteCount() {
            return this.count;
        }
    }
}

