/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v1.admin;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.XsrfCheckResult;
import com.atlassian.jira.security.xsrf.XsrfInvocationChecker;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserAdminHistoryManager;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugins.rest.api.security.annotation.CorsAllowed;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.atlassian.plugins.rest.api.security.exception.XsrfCheckFailedException;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="adminHistory")
@UnrestrictedAccess
@Consumes(value={"application/json", "application/x-www-form-urlencoded"})
@Produces(value={"application/json"})
@CorsAllowed
public class AdminHistoryResource {
    private final UserAdminHistoryManager adminHistoryManager;
    private final JiraAuthenticationContext authenticationContext;
    private final XsrfInvocationChecker xsrfChecker;

    @Inject
    public AdminHistoryResource(UserAdminHistoryManager adminHistoryManager, JiraAuthenticationContext authenticationContext, XsrfInvocationChecker xsrfChecker) {
        this.adminHistoryManager = adminHistoryManager;
        this.authenticationContext = authenticationContext;
        this.xsrfChecker = xsrfChecker;
    }

    @POST
    @Path(value="store")
    public void setHistory(AdminHistoryLink key) {
        XsrfCheckResult xsrfCheckResult = this.xsrfChecker.checkWebRequestInvocation(ExecutingHttpRequest.get());
        if (xsrfCheckResult.isRequired() && !xsrfCheckResult.isValid()) {
            throw new XsrfCheckFailedException();
        }
        ApplicationUser user = this.authenticationContext.getUser();
        this.adminHistoryManager.addAdminPageToHistory(user, key.id, key.url);
    }

    @XmlRootElement
    public static class AdminHistoryLink {
        @XmlElement
        private String id;
        @XmlElement
        private String url;

        private AdminHistoryLink() {
        }

        AdminHistoryLink(String id, String url) {
            this.id = id;
            this.url = url;
        }
    }
}

