/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.util;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.exception.AddException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.ForbiddenWebException;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.SimpleWarningCollection;
import com.atlassian.jira.util.WarningCollection;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateUserApplicationHelper {
    private final UserService userService;
    private final UserManager userManager;
    private final I18nHelper i18n;
    private final ApplicationRoleManager applicationRoleManager;
    private final GlobalPermissionManager permissionManager;
    private final JiraAuthenticationContext authContext;

    @Autowired
    public UpdateUserApplicationHelper(UserService userService, UserManager userManager, I18nHelper i18n, ApplicationRoleManager applicationRoleManager, GlobalPermissionManager permissionManager, JiraAuthenticationContext authContext) {
        this.userService = userService;
        this.userManager = userManager;
        this.i18n = i18n;
        this.applicationRoleManager = applicationRoleManager;
        this.permissionManager = permissionManager;
        this.authContext = authContext;
    }

    public ApplicationUpdateResult addUserToApplication(String username, String applicationKey) {
        return this.doApplicationUpdate(username, applicationKey, new ApplicationUpdateCommand(){

            @Override
            ApplicationUpdateResult execute(ApplicationUser user, ApplicationKey appKey) throws PermissionException, RemoveException, AddException {
                UserService.AddUserToApplicationValidationResult validationResult = UpdateUserApplicationHelper.this.userService.validateAddUserToApplication(user, appKey);
                if (!validationResult.isValid()) {
                    SimpleErrorCollection errorCollection = new SimpleErrorCollection(validationResult.getErrorCollection());
                    errorCollection.setReasons((Set)ImmutableSet.of((Object)ErrorCollection.Reason.VALIDATION_FAILED));
                    return new ApplicationUpdateResult(user, (com.atlassian.jira.util.ErrorCollection)errorCollection);
                }
                UpdateUserApplicationHelper.this.userService.addUserToApplication(validationResult);
                return new ApplicationUpdateResult(user);
            }
        });
    }

    public ApplicationUpdateResult removeUserFromApplication(String username, String applicationKey) {
        return this.doApplicationUpdate(username, applicationKey, new ApplicationUpdateCommand(){

            @Override
            ApplicationUpdateResult execute(ApplicationUser user, ApplicationKey appKey) throws PermissionException, RemoveException, AddException {
                UserService.RemoveUserFromApplicationValidationResult validationResult = UpdateUserApplicationHelper.this.userService.validateRemoveUserFromApplication(UpdateUserApplicationHelper.this.authContext.getLoggedInUser(), user, appKey);
                if (!validationResult.isValid()) {
                    SimpleErrorCollection errorCollection = new SimpleErrorCollection(validationResult.getErrorCollection());
                    errorCollection.setReasons((Set)ImmutableSet.of((Object)ErrorCollection.Reason.VALIDATION_FAILED));
                    return new ApplicationUpdateResult(user, (com.atlassian.jira.util.ErrorCollection)errorCollection);
                }
                UpdateUserApplicationHelper.this.userService.removeUserFromApplication(validationResult);
                return new ApplicationUpdateResult(user);
            }
        });
    }

    private void isCurrentUserLoggedInAndAdmin() {
        ApplicationUser loggedUser = this.authContext.getLoggedInUser();
        if (loggedUser == null) {
            throw new NotAuthorisedWebException(ErrorCollection.of(this.i18n.getText("rest.authentication.no.user.logged.in")));
        }
        boolean isGlobalAdmin = this.permissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, loggedUser);
        if (!isGlobalAdmin) {
            throw new ForbiddenWebException(ErrorCollection.of(this.i18n.getText("rest.authorization.admin.required")));
        }
    }

    private ApplicationUpdateResult doApplicationUpdate(String username, String applicationKey, ApplicationUpdateCommand command) {
        this.isCurrentUserLoggedInAndAdmin();
        if (username == null) {
            return this.updateError(this.i18n.getText("rest.user.error.no.username.param"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        ApplicationUser user = this.userManager.getUserByName(username);
        if (user == null) {
            return this.updateError(this.i18n.getText("rest.user.error.not.found", username), ErrorCollection.Reason.NOT_FOUND);
        }
        Either eitherApplicationKey = (Either)ApplicationKeys.TO_APPLICATION_KEY.apply((Object)applicationKey);
        if (eitherApplicationKey == null || eitherApplicationKey.isLeft()) {
            return this.updateError(this.i18n.getText("rest.user.error.not.valid.application.key", applicationKey), ErrorCollection.Reason.VALIDATION_FAILED, user);
        }
        ApplicationKey appKey = (ApplicationKey)eitherApplicationKey.right().get();
        try {
            return command.execute(user, appKey);
        }
        catch (PermissionException e) {
            return this.updateError(this.i18n.getText("error.no-permission"), ErrorCollection.Reason.FORBIDDEN, user);
        }
        catch (AddException | RemoveException e) {
            return this.updateError(e.getLocalizedMessage(), ErrorCollection.Reason.CONFLICT, user);
        }
    }

    private ApplicationUpdateResult updateError(String message, ErrorCollection.Reason reason, ApplicationUser user) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addErrorMessage(message, reason);
        return new ApplicationUpdateResult(user, (com.atlassian.jira.util.ErrorCollection)errorCollection);
    }

    private ApplicationUpdateResult updateError(String message, ErrorCollection.Reason reason) {
        return this.updateError(message, reason, null);
    }

    private static abstract class ApplicationUpdateCommand {
        private ApplicationUpdateCommand() {
        }

        abstract ApplicationUpdateResult execute(ApplicationUser var1, ApplicationKey var2) throws PermissionException, RemoveException, AddException;
    }

    public static class ApplicationUpdateResult
    implements ServiceResult {
        final com.atlassian.jira.util.ErrorCollection errorCollection;
        final Option<ApplicationUser> applicationUser;
        final WarningCollection warningCollection;

        public ApplicationUpdateResult(ApplicationUser applicationUser, com.atlassian.jira.util.ErrorCollection errorCollection, WarningCollection warningCollection) {
            this.errorCollection = errorCollection;
            this.applicationUser = Option.option((Object)applicationUser);
            this.warningCollection = warningCollection;
        }

        public ApplicationUpdateResult(ApplicationUser applicationUser, com.atlassian.jira.util.ErrorCollection errorCollection) {
            this(applicationUser, errorCollection, (WarningCollection)new SimpleWarningCollection());
        }

        public ApplicationUpdateResult(ApplicationUser applicationUser) {
            this(applicationUser, (com.atlassian.jira.util.ErrorCollection)new SimpleErrorCollection());
        }

        public boolean isValid() {
            return !this.errorCollection.hasAnyErrors();
        }

        public com.atlassian.jira.util.ErrorCollection getErrorCollection() {
            return this.errorCollection;
        }

        public WarningCollection getWarningCollection() {
            return this.warningCollection;
        }

        public Option<ApplicationUser> getApplicationUser() {
            return this.applicationUser;
        }
    }
}

