/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.util;

import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.StatusCategoryJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.StatusJsonBean;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.rest.util.StatusCategoryHelper;
import com.atlassian.jira.rest.v2.issue.ResourceUriBuilder;
import com.atlassian.jira.rest.v2.issue.StatusCategoryResource;
import java.net.MalformedURLException;
import java.net.URL;
import javax.ws.rs.core.UriInfo;

public class StatusHelper {
    private final JiraBaseUrls jiraBaseUrls;
    private final ResourceUriBuilder uriBuilder;
    private final StatusCategoryHelper statusCategoryHelper;

    public StatusHelper(JiraBaseUrls jiraBaseUrls, ResourceUriBuilder uriBuilder, StatusCategoryHelper statusCategoryHelper) {
        this.jiraBaseUrls = jiraBaseUrls;
        this.uriBuilder = uriBuilder;
        this.statusCategoryHelper = statusCategoryHelper;
    }

    public StatusJsonBean createStatusBean(Status status, UriInfo uriInfo, Class resourceClass) {
        Object absoluteIconUrl;
        try {
            absoluteIconUrl = new URL(status.getIconUrl()).toString();
        }
        catch (MalformedURLException e) {
            absoluteIconUrl = this.jiraBaseUrls.baseUrl() + status.getIconUrl();
        }
        return StatusJsonBean.bean((String)status.getId(), (String)status.getNameTranslation(), (String)this.uriBuilder.build(uriInfo, resourceClass, status.getId()).toString(), (String)absoluteIconUrl, (String)status.getDescTranslation(), (StatusCategoryJsonBean)this.statusCategoryHelper.createStatusCategoryBean(status.getStatusCategory(), uriInfo, StatusCategoryResource.class));
    }
}

