/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.util;

import io.atlassian.fugue.Either;
import java.util.regex.Pattern;

public class ProjectKeyOrId {
    private static final Pattern PROJECT_ID_PATTERN = Pattern.compile("^[1-9]\\d{0,17}$");

    public static Either<Long, String> parse(String projectKeyOrId) {
        return ProjectKeyOrId.isProjectId(projectKeyOrId) ? Either.left((Object)Long.parseLong(projectKeyOrId)) : Either.right((Object)projectKeyOrId);
    }

    private static boolean isProjectId(String projectIdOrKey) {
        return PROJECT_ID_PATTERN.matcher(projectIdOrKey).matches();
    }
}

