/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.util;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FilterPermissionHelper {
    private final SearchRequestService searchRequestService;

    @Autowired
    public FilterPermissionHelper(SearchRequestService searchRequestService) {
        this.searchRequestService = searchRequestService;
    }

    public ServiceOutcome<SearchRequest> addSharePermissionToSavedFilter(ApplicationUser user, SearchRequest filter, SharePermission sharePermission) {
        ImmutableSet shares = sharePermission.getType().equals((Object)ShareType.Name.GLOBAL) || sharePermission.getType().equals((Object)ShareType.Name.AUTHENTICATED) ? Collections.singleton(sharePermission) : ImmutableSet.builder().addAll((Iterable)filter.getPermissions().getPermissionSet()).add((Object)sharePermission).build();
        return this.updatePermissions(user, filter, (Set<SharePermission>)shares);
    }

    public ServiceOutcome<SearchRequest> removeSharePermissionFromSavedFilter(ApplicationUser user, SearchRequest filter, Long permissionId) {
        Set<SharePermission> newPermissionSet = filter.getPermissions().getPermissionSet().stream().filter(sharePermission -> !sharePermission.getId().equals(permissionId)).collect(Collectors.toSet());
        return this.updatePermissions(user, filter, newPermissionSet);
    }

    private ServiceOutcome<SearchRequest> updatePermissions(ApplicationUser user, SearchRequest filter, Set<SharePermission> permissions) {
        JiraServiceContextImpl context = new JiraServiceContextImpl(user);
        SearchRequest filterCopy = new SearchRequest(filter);
        filterCopy.setPermissions(new SharedEntity.SharePermissions(permissions));
        SearchRequest returnedValue = this.searchRequestService.updateFilter((JiraServiceContext)context, filterCopy);
        if (context.getErrorCollection().hasAnyErrors()) {
            return ServiceOutcomeImpl.from((ErrorCollection)context.getErrorCollection());
        }
        return ServiceOutcomeImpl.ok((Object)returnedValue);
    }
}

