/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v2.user;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.user.search.UserSearchIssueContext;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.mention.MentionableUserSearcher;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.internal.v2.user.UsersBean;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.rest.v2.issue.users.UserIssueRelevanceBean;
import com.atlassian.jira.rest.v2.issue.users.UserIssueRelevanceBeanBuilder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserIssueRelevance;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.I18nHelper;
import io.atlassian.fugue.Either;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class UserPickerResourceHelper {
    private final AvatarService avatarService;
    private final JiraAuthenticationContext authContext;
    private final I18nHelper.BeanFactory beanFactory;
    private final EmailFormatter emailFormatter;
    private final I18nHelper i18nBean;
    private final JiraBaseUrls jiraBaseUrls;
    private final MentionableUserSearcher mentionableUserSearcher;
    private final PermissionManager permissionManager;
    private final ProjectService projectService;
    private final TimeZoneManager timeZoneManager;
    private final UserSearchService userSearchService;
    private final IssueService issueService;

    public UserPickerResourceHelper(AvatarService avatarService, JiraAuthenticationContext authContext, I18nHelper.BeanFactory beanFactory, EmailFormatter emailFormatter, I18nHelper i18nBean, JiraBaseUrls jiraBaseUrls, MentionableUserSearcher mentionableUserSearcher, PermissionManager permissionManager, ProjectService projectService, TimeZoneManager timeZoneManager, UserSearchService userSearchService, IssueService issueService) {
        this.avatarService = avatarService;
        this.authContext = authContext;
        this.beanFactory = beanFactory;
        this.emailFormatter = emailFormatter;
        this.i18nBean = i18nBean;
        this.jiraBaseUrls = jiraBaseUrls;
        this.mentionableUserSearcher = mentionableUserSearcher;
        this.permissionManager = permissionManager;
        this.projectService = projectService;
        this.timeZoneManager = timeZoneManager;
        this.userSearchService = userSearchService;
        this.issueService = issueService;
    }

    UsersBean findUsersExtracted(@Nonnull String query, boolean includeInvolvement, @Nullable String issueKey, @Nullable List<String> projectKeys, int maxResults, @Nullable ApplicationUser loggedInUser, boolean forceReporterAndAssignee, ProjectPermissionKey loggedInUserPermissionKey, ProjectPermissionKey returnedUsersPermissionKey) {
        if (includeInvolvement && !StringUtils.isEmpty((CharSequence)issueKey)) {
            Relevance relevance = this.getRelevance(query, issueKey, maxResults, loggedInUser, forceReporterAndAssignee, returnedUsersPermissionKey);
            return new UsersBean(relevance.hasMore, this.mapToUserBeans(relevance.limitedRelevanceBeanByUser));
        }
        List<ApplicationUser> users = this.findUsers(query, issueKey, Objects.requireNonNull(projectKeys), maxResults, forceReporterAndAssignee, loggedInUserPermissionKey, returnedUsersPermissionKey);
        return new UsersBean(users.size() > maxResults, this.mapToUserBeans(loggedInUser, users.subList(0, Math.min(users.size(), maxResults))));
    }

    private Relevance getRelevance(@Nonnull String query, @Nonnull String issueKey, int maxResults, @Nullable ApplicationUser loggedInUser, boolean forceReporterAndAssignee, @Nonnull ProjectPermissionKey returnedUsersPermissionKey) {
        MutableIssue issue = this.getIssueObject(loggedInUser, issueKey);
        Map<ApplicationUser, UserIssueRelevanceBean> relevanceBeanByUser = this.getUserIssueRelevanceBeanByUser(query, maxResults + 1, (Issue)issue, loggedInUser, () -> this.findUsers(query, issueKey, maxResults + 1, forceReporterAndAssignee, returnedUsersPermissionKey));
        Map limitedRelevanceBeanByUser = relevanceBeanByUser.entrySet().stream().limit(maxResults).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b, LinkedHashMap::new));
        return new Relevance(relevanceBeanByUser.size() > maxResults, limitedRelevanceBeanByUser);
    }

    private MutableIssue getIssueObject(@Nullable ApplicationUser user, @Nonnull String issueKey) {
        IssueService.IssueResult result = this.issueService.getIssue(user, issueKey);
        com.atlassian.jira.util.ErrorCollection errorCollection = result.getErrorCollection();
        if (errorCollection.hasAnyErrors()) {
            throw new RESTException(ErrorCollection.of(errorCollection));
        }
        return result.getIssue();
    }

    private List<Project> getProjectObjects(@Nonnull List<String> projectKeys) {
        List projectResults = projectKeys.stream().map(arg_0 -> ((ProjectService)this.projectService).getProjectByKey(arg_0)).collect(Collectors.toList());
        if (projectResults.stream().anyMatch(result -> result.getErrorCollection().hasAnyErrors())) {
            com.atlassian.jira.util.ErrorCollection errorCollection = projectResults.stream().map(ServiceResultImpl::getErrorCollection).reduce((errorCollection1, errorCollection2) -> {
                errorCollection1.addErrorCollection(errorCollection2);
                return errorCollection1;
            }).get();
            throw new RESTException(ErrorCollection.of(errorCollection));
        }
        return projectResults.stream().map(ProjectService.AbstractProjectResult::get).collect(Collectors.toList());
    }

    private List<ApplicationUser> findUsers(@Nonnull String query, @Nullable String issueKey, @Nonnull List<String> projectKeys, int maxResults, boolean forceReporterAndAssignee, @Nonnull ProjectPermissionKey loggedInUserPermissionKey, @Nonnull ProjectPermissionKey returnedUsersPermissionKey) {
        if (!StringUtils.isEmpty((CharSequence)issueKey)) {
            return this.findUsers(query, issueKey, maxResults + 1, forceReporterAndAssignee, returnedUsersPermissionKey);
        }
        Either<ErrorCollection, List<Project>> errorOrProjects = this.getProjects(projectKeys, loggedInUserPermissionKey);
        if (errorOrProjects.isLeft()) {
            throw new RESTException((ErrorCollection)errorOrProjects.left().get());
        }
        return this.findUsers(query, (List)errorOrProjects.right().get(), maxResults + 1, forceReporterAndAssignee, returnedUsersPermissionKey);
    }

    private List<ApplicationUser> findUsers(@Nonnull String query, @Nonnull String issueKey, int maxResults, boolean forceReporterAndAssignee, @Nonnull ProjectPermissionKey permissionKey) {
        MutableIssue issue = this.getIssueObject(this.authContext.getLoggedInUser(), issueKey);
        return this.findUsers(query, UserSearchIssueContext.create((Issue)issue), maxResults, forceReporterAndAssignee, permissionKey);
    }

    private List<ApplicationUser> findUsers(@Nonnull String query, @Nonnull List<Project> projects, int maxResults, boolean forceReporterAndAssignee, @Nonnull ProjectPermissionKey permissionKey) {
        return this.findUsers(query, UserSearchIssueContext.createForNewIssue(projects), maxResults, forceReporterAndAssignee, permissionKey);
    }

    private List<ApplicationUser> findUsers(String query, @Nonnull UserSearchIssueContext userSearchIssueContext, int maxResults, boolean forceReporterAndAssignee, @Nonnull ProjectPermissionKey permissionKey) {
        return this.userSearchService.findTopUsers(query, userSearchIssueContext, maxResults, permissionKey, forceReporterAndAssignee);
    }

    private Either<ErrorCollection, List<Project>> getProjects(List<String> projectKeys) {
        ArrayList<Project> projects = new ArrayList<Project>(projectKeys.size());
        for (String projectKey : projectKeys) {
            ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKeyForAction(this.authContext.getLoggedInUser(), projectKey, ProjectAction.VIEW_PROJECT);
            if (projectResult.getErrorCollection().hasAnyErrors()) {
                return Either.left((Object)ErrorCollection.of(projectResult.getErrorCollection()));
            }
            projects.add(projectResult.getProject());
        }
        return Either.right(projects);
    }

    private Either<ErrorCollection, List<Project>> getProjects(List<String> projectKeys, ProjectPermissionKey permissionKey) {
        ApplicationUser loggedInUser = this.authContext.getLoggedInUser();
        return this.getProjects(projectKeys).map(projects -> {
            projects.stream().filter(project -> !this.permissionManager.hasPermission(permissionKey, project, loggedInUser)).findFirst().ifPresent(project -> {
                throw new RESTException(Response.Status.NOT_FOUND, this.i18nBean.getText("admin.errors.project.not.found.for.key"));
            });
            return projects;
        });
    }

    private Map<ApplicationUser, UserIssueRelevanceBean> getUserIssueRelevanceBeanByUser(@Nonnull String query, int maxResults, @Nonnull Issue issue, @Nullable ApplicationUser loggedInUser, @Nonnull Supplier<List<ApplicationUser>> userSupplier) {
        UserIssueRelevanceBeanBuilder relevanceBeanBuilder = this.getUserIssueRelevanceBeanBuilder(loggedInUser);
        return this.mentionableUserSearcher.findRelatedUsersToMention(query, issue, loggedInUser, maxResults, userSupplier).stream().collect(Collectors.toMap(UserIssueRelevance::getUser, relevanceBeanBuilder::build, (a, b) -> b, LinkedHashMap::new));
    }

    private UserIssueRelevanceBeanBuilder getUserIssueRelevanceBeanBuilder(@Nullable ApplicationUser loggedInUser) {
        return new UserIssueRelevanceBeanBuilder(this.emailFormatter, this.beanFactory.getInstance(loggedInUser), this.jiraBaseUrls, loggedInUser, this.timeZoneManager.getTimeZoneforUser(loggedInUser), this.avatarService);
    }

    private List<UsersBean.UserBean> mapToUserBeans(@Nullable ApplicationUser loggedInUser, @Nonnull List<ApplicationUser> users) {
        return users.stream().map(user -> new UsersBean.UserBean(this.avatarService.getAvatarURL(loggedInUser, user), user.getDisplayName(), this.emailFormatter.formatEmail(user.getEmailAddress(), loggedInUser), user.getName())).collect(Collectors.toList());
    }

    private List<UsersBean.UserBean> mapToUserBeans(@Nonnull Map<ApplicationUser, UserIssueRelevanceBean> relevanceBeanByUser) {
        return relevanceBeanByUser.values().stream().map(relevanceBean -> new UsersBean.UserBean(relevanceBean.getAvatarUrls().get(String.format("%1$dx%1$d", Avatar.Size.LARGE.getPixels())), relevanceBean.getDisplayName(), relevanceBean.getEmailAddress(), relevanceBean.getName(), relevanceBean.getIssueInvolvements(), relevanceBean.getHighestIssueInvolvementRank(), relevanceBean.getLatestCommentCreationTime())).collect(Collectors.toList());
    }

    boolean checkUserPermission(ApplicationUser user, List<Project> projects, ProjectPermissionKey permissionKey) {
        return projects.stream().allMatch(project -> this.permissionManager.hasPermission(permissionKey, project, user));
    }

    public List<Project> getProjectsIssueFirst(ApplicationUser user, String issueKey, List<String> projectKeys) {
        if (StringUtils.isEmpty((CharSequence)issueKey) && CollectionUtils.isEmpty(projectKeys)) {
            throw new RESTException(Response.Status.BAD_REQUEST, ErrorCollection.of(this.i18nBean.getText("common.forms.ajax.invalid.arguments")));
        }
        if (!StringUtils.isEmpty((CharSequence)issueKey)) {
            return Collections.singletonList(this.getIssueObject(user, issueKey).getProjectObject());
        }
        return this.getProjectObjects(projectKeys);
    }

    private static class Relevance {
        private final boolean hasMore;
        private final Map<ApplicationUser, UserIssueRelevanceBean> limitedRelevanceBeanByUser;

        public Relevance(boolean hasMore, Map<ApplicationUser, UserIssueRelevanceBean> limitedRelevanceBeanByUser) {
            this.hasMore = hasMore;
            this.limitedRelevanceBeanByUser = limitedRelevanceBeanByUser;
        }
    }
}

