/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v2.user;

import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.permission.UserSearchConfiguration;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.internal.v2.user.UserPickerResourceHelper;
import com.atlassian.jira.rest.internal.v2.user.UsersBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
@Path(value="users")
@Produces(value={"application/json"})
public class UserPickerResource {
    private static final String DEFAULT_MAX_RESULTS_STR = "50";
    private static final String DELIMITER = ",";
    private static final int MAX_MAX_RESULTS = UserSearchConfiguration.getMaxTopReturnedUsersValue();
    private static final int MIN_MAX_RESULTS = 1;
    private final JiraAuthenticationContext authContext;
    private final UserPickerResourceHelper resourceHelper;

    @Inject
    public UserPickerResource(JiraAuthenticationContext authContext, UserPickerResourceHelper resourceHelper) {
        this.authContext = authContext;
        this.resourceHelper = resourceHelper;
    }

    @GET
    @Path(value="assignee")
    public Response findAssignableUsers(@QueryParam(value="includeInvolvement") @DefaultValue(value="false") boolean includeInvolvement, @QueryParam(value="issueKey") @DefaultValue(value="") String issueKey, @QueryParam(value="maxResults") @DefaultValue(value="50") int maxResults, @QueryParam(value="projectKeys") @DefaultValue(value="") String projectKeys, @QueryParam(value="query") @DefaultValue(value="") String query) {
        return this.findAssignableUsersCommon(includeInvolvement, issueKey, maxResults, projectKeys, query);
    }

    @GET
    @Path(value="assignee/multiProjectSearch")
    public Response findAssignableUsersInProjects(@QueryParam(value="maxResults") @DefaultValue(value="50") int maxResults, @QueryParam(value="projectKeys") @DefaultValue(value="") String projectKeys, @QueryParam(value="query") @DefaultValue(value="") String query) {
        return this.findAssignableUsersCommon(false, null, maxResults, projectKeys, query);
    }

    @GET
    @Path(value="mention")
    public Response findMentionableUsers(@QueryParam(value="includeInvolvement") @DefaultValue(value="false") boolean includeInvolvement, @QueryParam(value="issueKey") @DefaultValue(value="") String issueKey, @QueryParam(value="maxResults") @DefaultValue(value="50") int maxResults, @QueryParam(value="projectKeys") @DefaultValue(value="") String projectKeys, @QueryParam(value="query") @DefaultValue(value="") String query) {
        ApplicationUser loggedInUser = this.authContext.getLoggedInUser();
        List<String> projectKeysParsed = this.getProjectKeys(projectKeys);
        this.checkPermissions(loggedInUser, issueKey, projectKeysParsed, ProjectPermissions.BROWSE_PROJECTS);
        int clampedMaxResults = UserPickerResource.clampMaxResults(maxResults);
        UsersBean usersBean = this.resourceHelper.findUsersExtracted(query, includeInvolvement, issueKey, this.getProjectKeys(projectKeys), clampedMaxResults, loggedInUser, true, ProjectPermissions.BROWSE_PROJECTS, ProjectPermissions.BROWSE_PROJECTS);
        return Response.ok(usersBean.users).cacheControl(CacheControl.never()).build();
    }

    private void checkPermissions(ApplicationUser loggedInUser, String issueKey, List<String> projectKeysParsed, ProjectPermissionKey projectPermissionKey) {
        if (!this.resourceHelper.checkUserPermission(loggedInUser, this.resourceHelper.getProjectsIssueFirst(loggedInUser, issueKey, projectKeysParsed), projectPermissionKey)) {
            throw new NotAuthorisedWebException();
        }
    }

    @GET
    @Path(value="reporter")
    public Response findReporterUsers(@QueryParam(value="includeInvolvement") @DefaultValue(value="false") boolean includeInvolvement, @QueryParam(value="issueKey") @DefaultValue(value="") String issueKey, @QueryParam(value="maxResults") @DefaultValue(value="100") int maxResults, @QueryParam(value="projectKeys") @DefaultValue(value="") String projectKeys, @QueryParam(value="query") @DefaultValue(value="") String query) {
        ApplicationUser loggedInUser = this.authContext.getLoggedInUser();
        List<String> projectKeysParsed = this.getProjectKeys(projectKeys);
        this.checkPermissions(loggedInUser, issueKey, projectKeysParsed, ProjectPermissions.MODIFY_REPORTER);
        int clampedMaxResults = UserPickerResource.clampMaxResults(maxResults);
        UsersBean usersBean = this.resourceHelper.findUsersExtracted(query, includeInvolvement, issueKey, projectKeysParsed, clampedMaxResults, loggedInUser, false, ProjectPermissions.MODIFY_REPORTER, ProjectPermissions.BROWSE_PROJECTS);
        return Response.ok((Object)usersBean).cacheControl(CacheControl.never()).build();
    }

    private static int clampMaxResults(int maxResults) {
        return Math.min(Math.max(maxResults, 1), MAX_MAX_RESULTS);
    }

    private Response findAssignableUsersCommon(boolean includeInvolvement, @Nullable String issueKey, int maxResults, @Nonnull String projectKeys, @Nonnull String query) {
        ApplicationUser loggedInUser = this.authContext.getLoggedInUser();
        List<String> projectKeysParsed = this.getProjectKeys(projectKeys);
        this.checkPermissions(loggedInUser, issueKey, projectKeysParsed, ProjectPermissions.ASSIGN_ISSUES);
        int clampedMaxResults = UserPickerResource.clampMaxResults(maxResults);
        UsersBean usersBean = this.resourceHelper.findUsersExtracted(query, includeInvolvement, issueKey, projectKeysParsed, clampedMaxResults, loggedInUser, false, ProjectPermissions.ASSIGN_ISSUES, ProjectPermissions.ASSIGNABLE_USER);
        return Response.ok((Object)usersBean).cacheControl(CacheControl.never()).build();
    }

    private List<String> getProjectKeys(String projectKeys) {
        return Arrays.asList(StringUtils.split((String)projectKeys, (String)DELIMITER));
    }
}

