/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v2.user;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.rest.IssueFinder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.mention.MentionableUserSearcher;
import com.atlassian.jira.permission.UserSearchConfiguration;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.v2.issue.users.UserIssueRelevanceBean;
import com.atlassian.jira.rest.v2.issue.users.UserIssueRelevanceBeanBuilder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="user/mention")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@LicensedOnly
public class MentionResource {
    private static final int MIN_USERS_RETURNED = 1;
    private static final int DEFAULT_USERS_RETURNED = 50;
    private static final int MAX_USERS_RETURNED = UserSearchConfiguration.getMaxTopReturnedUsersValue();
    private final EmailFormatter emailFormatter;
    private final I18nHelper.BeanFactory beanFactory;
    private final IssueFinder issueFinder;
    private final JiraAuthenticationContext authContext;
    private final JiraBaseUrls jiraBaseUrls;
    private final MentionableUserSearcher mentionableUserSearch;
    private final TimeZoneManager timeZoneManager;
    private final AvatarService avatarService;

    @Inject
    public MentionResource(EmailFormatter emailFormatter, I18nHelper.BeanFactory beanFactory, IssueFinder issueFinder, JiraAuthenticationContext authContext, JiraBaseUrls jiraBaseUrls, @ComponentImport MentionableUserSearcher mentionableUserSearch, TimeZoneManager timeZoneManager, AvatarService avatarService) {
        this.emailFormatter = emailFormatter;
        this.beanFactory = beanFactory;
        this.issueFinder = issueFinder;
        this.authContext = authContext;
        this.jiraBaseUrls = jiraBaseUrls;
        this.mentionableUserSearch = mentionableUserSearch;
        this.timeZoneManager = timeZoneManager;
        this.avatarService = avatarService;
    }

    @GET
    @Path(value="search")
    @Operation(description="Returns a list of users who are relevant to the issue and match the query string. The users are sorted by 'relevance' to the issue, with most relevant appearing first in the list.")
    @Parameters(value={@Parameter(name="query", description="The username filter, no users returned if left blank"), @Parameter(name="issueKey", description="The issue key for the issue being edited we need to find viewable users for."), @Parameter(name="maxResults", description="The maximum number of users to return (defaults to 50). The maximum allowed value is 100.")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns a full representation of a Jira user with relevancy information in JSON format.", content={@Content(schema=@Schema(implementation=UserIssueRelevanceBean.class), mediaType="application/json")}), @ApiResponse(responseCode="401", description="Returned if the current user is not authenticated.")})
    public Response search(@QueryParam(value="query") String query, @QueryParam(value="issueKey") String issueKey, @QueryParam(value="maxResults") Integer maxResults) {
        maxResults = maxResults == null ? 50 : MentionResource.clamp(maxResults, 1, MAX_USERS_RETURNED);
        ApplicationUser loggedInUser = this.authContext.getLoggedInUser();
        Issue issue = this.issueFinder.findIssue(issueKey, (ErrorCollection)new SimpleErrorCollection());
        List involvedUsers = this.mentionableUserSearch.findRelatedUsersToMention(query, issue, loggedInUser, maxResults.intValue());
        UserIssueRelevanceBeanBuilder userIssueRelevanceBeanBuilder = new UserIssueRelevanceBeanBuilder(this.emailFormatter, this.beanFactory.getInstance(loggedInUser), this.jiraBaseUrls, loggedInUser, this.timeZoneManager.getTimeZoneforUser(loggedInUser), this.avatarService);
        List userBeans = (List)involvedUsers.stream().map(userIssueRelevanceBeanBuilder::build).collect(CollectorsUtil.toImmutableList());
        return Response.ok((Object)userBeans).cacheControl(CacheControl.never()).build();
    }

    private static int clamp(int n, int min, int max) {
        return n < min ? min : (n > max ? max : n);
    }
}

