/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v2.project;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.project.ProjectOrderByManager;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.BadRequestWebException;
import com.atlassian.jira.rest.exception.ForbiddenWebException;
import com.atlassian.jira.rest.internal.v2.project.OrderByPreferences;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="project-preferences")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@LicensedOnly
public class ProjectPreferencesResource {
    private final ProjectOrderByManager projectOrderByManager;
    private final JiraAuthenticationContext authContext;

    @Inject
    public ProjectPreferencesResource(@ComponentImport ProjectOrderByManager projectOrderByManager, @ComponentImport JiraAuthenticationContext authContext) {
        this.projectOrderByManager = projectOrderByManager;
        this.authContext = authContext;
    }

    @POST
    public Response saveOrderByPreferences(OrderByPreferences orderByPreferences) {
        if (orderByPreferences == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            this.projectOrderByManager.updateProjectPreferredOrderByOption(orderByPreferences.projectId(), this.authContext.getLoggedInUser(), orderByPreferences.orderByOption());
            return Response.ok().build();
        }
        catch (PermissionException e) {
            throw new ForbiddenWebException(ErrorCollection.of(e.getMessage()));
        }
        catch (RuntimeException e) {
            throw new BadRequestWebException(ErrorCollection.of(e.getMessage()));
        }
    }

    @GET
    @Path(value="/{projectId}")
    public Response collectOrderByPreferences(@PathParam(value="projectId") long projectId) {
        try {
            String result = this.projectOrderByManager.getProjectPreferredOrderByOption(projectId, this.authContext.getLoggedInUser()).orElse(null);
            return Response.ok((Object)result).build();
        }
        catch (PermissionException e) {
            throw new ForbiddenWebException(ErrorCollection.of(e.getMessage()));
        }
        catch (RuntimeException e) {
            throw new BadRequestWebException(ErrorCollection.of(e.getMessage()));
        }
    }
}

