/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v2.permissions;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.jira.permission.management.ManagedPermissionSchemeHelper;
import com.atlassian.jira.permission.management.beans.PermissionsInputBean;
import com.atlassian.jira.permission.management.beans.ProjectDeleteInstructionsBean;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.atlassian.fugue.Either;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="managedpermissionscheme")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@WebSudoRequired
@LicensedOnly
public class ManagedPermissionSchemeResource {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ResponseFactory responseFactory;
    private final ManagedPermissionSchemeHelper managedPermission;

    @Inject
    public ManagedPermissionSchemeResource(JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport ManagedPermissionSchemeHelper managedPermission, ResponseFactory responseFactory) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.managedPermission = managedPermission;
        this.responseFactory = responseFactory;
    }

    @GET
    @Path(value="{permissionSchemeId}")
    public Response getManagedPermissionScheme(@PathParam(value="permissionSchemeId") Long permissionSchemeId) {
        return this.toResponse(this.managedPermission.getManagedPermissionScheme(this.getLoggedInUser(), permissionSchemeId));
    }

    @GET
    @Path(value="securitytypes")
    public Response getManagedPermissionSchemeAddViewSecurityTypes() {
        return this.toResponse(this.managedPermission.getManagedPermissionSchemeAddViewSecurityTypes(this.getLoggedInUser()));
    }

    @GET
    @Path(value="{permissionSchemeId}/{permissionKey}")
    public Response getManagedPermissionSchemeAddView(@PathParam(value="permissionSchemeId") Long permissionSchemeId, @PathParam(value="permissionKey") String permissionKey) {
        return this.toResponse(this.managedPermission.getManagedPermissionSchemeAddView(this.getLoggedInUser(), permissionSchemeId, permissionKey));
    }

    @POST
    @Path(value="{permissionSchemeId}")
    public Response addManagedPermissionSchemeGrants(@PathParam(value="permissionSchemeId") Long permissionSchemeId, PermissionsInputBean addPermissions) {
        return this.toResponse(this.managedPermission.addManagedPermissionSchemeGrants(this.getLoggedInUser(), permissionSchemeId, addPermissions));
    }

    @DELETE
    @Path(value="{permissionSchemeId}")
    public Response removeManagedPermissionSchemeGrants(@PathParam(value="permissionSchemeId") Long permissionSchemeId, ProjectDeleteInstructionsBean deleteInstructionsBean) {
        return this.toResponse(this.managedPermission.removeManagedPermissionSchemeGrants(this.getLoggedInUser(), permissionSchemeId, deleteInstructionsBean.getGrantsToDelete()));
    }

    private <T> Response toResponse(Either<ErrorCollection, T> result) {
        return (Response)this.responseFactory.toResponse(result).left().on(this.responseFactory::okNoCache);
    }

    private ApplicationUser getLoggedInUser() {
        return this.jiraAuthenticationContext.getLoggedInUser();
    }
}

