/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v2.field.renderer;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.issue.fields.renderer.EditorMarkupParameters;
import com.atlassian.jira.issue.fields.renderer.EditorMarkupService;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.Collection;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.springframework.web.bind.annotation.RequestBody;

@Path(value="field/markup")
@Consumes(value={"application/json"})
@Produces(value={"text/html", "application/json"})
@AnonymousSiteAccess
public class EditorMarkupResource {
    private static final int ONE_DAY = 86400;
    private final EditorMarkupService editorMarkupService;

    @Inject
    public EditorMarkupResource(@ComponentImport EditorMarkupService editorMarkupService) {
        this.editorMarkupService = editorMarkupService;
    }

    @Operation(summary="Returns generated input field html for given parameters", description="Returns generated input field html for given parameters")
    @io.swagger.v3.oas.annotations.parameters.RequestBody(description="An object containing field parameters", content={@Content(schema=@Schema(implementation=EditorMarkupParameters.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returned if the html for input field was successfully generated", content={@Content(mediaType="text/html")}), @ApiResponse(responseCode="400", description="Returned if validation of provided parameters failed", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="500", description="Returned if an error occurs while generating the response", content={@Content(mediaType="application/json")})})
    @POST
    public Response getEditorMarkupForField(@RequestBody EditorMarkupParameters parameters) {
        ServiceOutcome outcome = this.editorMarkupService.getEditorMarkupForField(parameters);
        if (outcome.isValid()) {
            return Response.ok().entity(outcome.get()).cacheControl(this.saveCacheForOneDay()).build();
        }
        return this.errorResponse(outcome.getErrorCollection());
    }

    private Response errorResponse(com.atlassian.jira.util.ErrorCollection errorCollection) {
        ErrorCollection.Reason worstReason = ErrorCollection.Reason.getWorstReason((Collection)errorCollection.getReasons());
        if (worstReason == null) {
            worstReason = ErrorCollection.Reason.SERVER_ERROR;
        }
        return Response.status((int)worstReason.getHttpStatusCode()).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)ErrorCollection.of(errorCollection)).cacheControl(CacheControl.never()).build();
    }

    private javax.ws.rs.core.CacheControl saveCacheForOneDay() {
        javax.ws.rs.core.CacheControl cacheControl = new javax.ws.rs.core.CacheControl();
        cacheControl.setMaxAge(86400);
        return cacheControl;
    }
}

