/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v2.field.config;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItem;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.EditableDefaultFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutService;
import com.atlassian.jira.issue.fields.renderer.DefaultHackyFieldRendererRegistry;
import com.atlassian.jira.issue.fields.renderer.HackyFieldRendererRegistry;
import com.atlassian.jira.issue.fields.renderer.HackyRendererType;
import com.atlassian.jira.issue.fields.renderer.RenderableField;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.ProjectJsonBean;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.internal.v2.field.config.FieldActionBean;
import com.atlassian.jira.rest.internal.v2.field.config.FieldActionsBean;
import com.atlassian.jira.rest.internal.v2.field.config.FieldActionsToggleBean;
import com.atlassian.jira.rest.internal.v2.field.config.FieldConfigurationBean;
import com.atlassian.jira.rest.internal.v2.field.config.FieldConfigurationProjectsBean;
import com.atlassian.jira.rest.internal.v2.field.config.FieldLayoutItemBean;
import com.atlassian.jira.rest.internal.v2.field.config.FieldScreenTabBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.function.TriConsumer;

@Path(value="fieldConfiguration")
@Produces(value={"application/json"})
@LicensedOnly
public class FieldConfigurationResource {
    private final FieldLayoutManager fieldLayoutManager;
    private final ManagedConfigurationItemService managedConfigurationItemService;
    private final FieldScreenManager fieldScreenManager;
    private final FieldManager fieldManager;
    private final RendererManager rendererManager;
    private final JiraBaseUrls jiraBaseUrls;
    private final FieldLayoutService fieldLayoutService;
    private final HackyFieldRendererRegistry hackyFieldRendererRegistry;
    private final I18nHelper i18nHelper;
    private final JiraAuthenticationContext authContext;
    private static final String FIELD_ID_PARAMETER = "fieldId";
    private static final String ID_PARAMETER = "id";

    @Inject
    public FieldConfigurationResource(FieldManager fieldManager, FieldLayoutManager fieldLayoutManager, FieldScreenManager fieldScreenManager, ManagedConfigurationItemService managedConfigurationItemService, RendererManager rendererManager, @ComponentImport FieldLayoutService fieldLayoutService, JiraBaseUrls jiraBaseUrls, I18nHelper i18nHelper, JiraAuthenticationContext authContext) {
        this.fieldLayoutManager = fieldLayoutManager;
        this.managedConfigurationItemService = managedConfigurationItemService;
        this.fieldScreenManager = fieldScreenManager;
        this.fieldManager = fieldManager;
        this.rendererManager = rendererManager;
        this.fieldLayoutService = fieldLayoutService;
        this.i18nHelper = i18nHelper;
        this.authContext = authContext;
        this.hackyFieldRendererRegistry = new DefaultHackyFieldRendererRegistry();
        this.jiraBaseUrls = jiraBaseUrls;
    }

    @GET
    @Path(value="{configId}")
    public Response getConfiguration(@PathParam(value="configId") Long configId, @QueryParam(value="page") @DefaultValue(value="1") int page, @QueryParam(value="maxResults") @DefaultValue(value="10") int maxResults, @QueryParam(value="query") @DefaultValue(value="") String query) {
        if (page >= 1 && maxResults >= 1 && query != null) {
            EditableFieldLayout fieldLayout = this.getFieldLayout(configId);
            if (this.parseConfigId(configId) == null || Objects.equals(fieldLayout.getId(), this.parseConfigId(configId))) {
                List filteredLayoutItems = (List)this.fieldLayoutService.getFilteredLayoutItems((FieldLayout)fieldLayout, query, this.authContext.getLoggedInUser()).get();
                List<FieldLayoutItemBean> layoutBeans = filteredLayoutItems.stream().skip((long)(page - 1) * (long)maxResults).map(layoutItem -> {
                    OrderableField orderableField = layoutItem.getOrderableField();
                    return new FieldLayoutItemBean(orderableField.getId(), orderableField.getName(), layoutItem.getRawFieldDescription(), this.isFieldLocked((Field)orderableField), this.isFieldManaged((Field)orderableField), layoutItem.isRequired(), layoutItem.isHidden(), this.isHideable((FieldLayoutItem)layoutItem), this.isRequirable((FieldLayoutItem)layoutItem), this.getRendererDisplayName((FieldLayoutItem)layoutItem), this.getScreens((FieldLayoutItem)layoutItem).stream().map(fieldScreenTab -> {
                        FieldScreen fieldScreen = fieldScreenTab.getFieldScreen();
                        return new FieldScreenTabBean(fieldScreen.getId(), fieldScreen.getName(), fieldScreenTab.getName(), this.getScreenUrl(fieldScreen.getId()));
                    }).collect(Collectors.toList()), this.createFieldActionsBean((FieldLayoutItem)layoutItem, layoutItem.getFieldLayout().getId()));
                }).limit(maxResults).collect(Collectors.toList());
                return Response.ok((Object)new FieldConfigurationBean(fieldLayout.getName(), fieldLayout.isDefault(), Long.valueOf(filteredLayoutItems.size()), layoutBeans)).build();
            }
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="{configId}/projects")
    public Response getProjectsForConfiguration(@PathParam(value="configId") Long configId) {
        EditableFieldLayout fieldLayout = this.getFieldLayout(configId);
        if (fieldLayout != null && (this.parseConfigId(configId) == null || Objects.equals(fieldLayout.getId(), this.parseConfigId(configId)))) {
            List<ProjectJsonBean> projects = this.fieldLayoutManager.getProjectsUsing((FieldLayout)fieldLayout).stream().map(project -> ProjectJsonBean.shortBean((Project)project, (JiraBaseUrls)this.jiraBaseUrls)).sorted(Comparator.comparing(ProjectJsonBean::getName)).collect(Collectors.toList());
            return Response.ok((Object)new FieldConfigurationProjectsBean(projects)).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @PUT
    @Path(value="{configId}/{fieldId}/hide/{hidden}")
    public Response setHidden(@PathParam(value="configId") Long configId, @PathParam(value="fieldId") String fieldId, @PathParam(value="hidden") boolean hidden) {
        return this.handleFieldToggleRequest(configId, fieldId, hidden, (TriConsumer<Boolean, EditableFieldLayout, FieldLayoutItem>)((TriConsumer)FieldConfigurationResource::toggleHidden));
    }

    @PUT
    @Path(value="{configId}/{fieldId}/require/{required}")
    public Response setRequired(@PathParam(value="configId") Long configId, @PathParam(value="fieldId") String fieldId, @PathParam(value="required") boolean required) {
        return this.handleFieldToggleRequest(configId, fieldId, required, (TriConsumer<Boolean, EditableFieldLayout, FieldLayoutItem>)((TriConsumer)FieldConfigurationResource::toggleRequired));
    }

    private Response handleFieldToggleRequest(Long configId, String fieldId, boolean property, TriConsumer<Boolean, EditableFieldLayout, FieldLayoutItem> handler) {
        FieldLayoutItem field;
        EditableFieldLayout fieldLayout = this.getFieldLayout(configId);
        if (fieldLayout != null && (field = fieldLayout.getFieldLayoutItem(fieldId)) != null) {
            try {
                handler.accept((Object)property, (Object)fieldLayout, (Object)field);
                if (this.parseConfigId(configId) == null) {
                    this.fieldLayoutManager.storeEditableDefaultFieldLayout((EditableDefaultFieldLayout)fieldLayout);
                } else {
                    this.fieldLayoutManager.storeEditableFieldLayout(fieldLayout);
                }
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            FieldLayoutItem newField = this.getFieldLayout(configId).getFieldLayoutItem(fieldId);
            return Response.ok((Object)new FieldActionsToggleBean(newField.isRequired(), newField.isHidden())).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    private static void toggleHidden(boolean hidden, EditableFieldLayout fieldLayout, FieldLayoutItem field) {
        if (hidden) {
            fieldLayout.hide(field);
        } else {
            fieldLayout.show(field);
        }
    }

    private static void toggleRequired(boolean required, EditableFieldLayout fieldLayout, FieldLayoutItem field) {
        if (required) {
            fieldLayout.makeRequired(field);
        } else {
            fieldLayout.makeOptional(field);
        }
    }

    public boolean isHideable(FieldLayoutItem fieldLayoutItem) {
        return this.fieldManager.isHideableField((Field)fieldLayoutItem.getOrderableField());
    }

    public boolean isRequirable(FieldLayoutItem fieldLayoutItem) {
        return this.fieldManager.isRequirableField((Field)fieldLayoutItem.getOrderableField());
    }

    private boolean isFieldManaged(Field field) {
        if (!(field instanceof CustomField)) {
            return false;
        }
        CustomField customField = (CustomField)field;
        ManagedConfigurationItem item = this.managedConfigurationItemService.getManagedCustomField(customField);
        return item.isManaged();
    }

    private Collection<FieldScreenTab> getScreens(FieldLayoutItem fieldLayoutItem) {
        return this.fieldScreenManager.getFieldScreenTabs(fieldLayoutItem.getOrderableField().getId());
    }

    private boolean isFieldLocked(Field field) {
        return field instanceof CustomField && this.isFieldManaged(field);
    }

    private String getRendererDisplayName(FieldLayoutItem fieldLayoutItem) {
        if (!this.isRenderable(fieldLayoutItem.getOrderableField())) {
            return null;
        }
        String rendererType = fieldLayoutItem.getRendererType();
        HackyRendererType hackyRendererType = HackyRendererType.fromKey((String)rendererType);
        if (hackyRendererType != null) {
            return this.i18nHelper.getText(hackyRendererType.getDisplayNameI18nKey());
        }
        return this.rendererManager.getRendererForType(rendererType).getDescriptor().getName();
    }

    private boolean isRenderable(OrderableField field) {
        if (field instanceof RenderableField) {
            RenderableField renderableField = (RenderableField)field;
            boolean isRenderable = renderableField.isRenderable();
            if (!isRenderable && field instanceof CustomField) {
                return this.hackyFieldRendererRegistry.shouldOverrideDefaultRenderers(field);
            }
            return isRenderable;
        }
        return this.hackyFieldRendererRegistry.shouldOverrideDefaultRenderers(field);
    }

    private String getScreenUrl(Long id) {
        return new UrlBuilder(this.jiraBaseUrls.baseUrl()).addPaths("/secure/admin/ConfigureFieldScreen.jspa").addParameter(ID_PARAMETER, id.toString()).asUrlString();
    }

    private String getEditUrl(String fieldId, Long layoutId) {
        return new UrlBuilder(this.jiraBaseUrls.baseUrl().concat("/secure/admin/EditFieldLayoutItem!default.jspa")).addParameter(ID_PARAMETER, (Object)layoutId).addParameter(FIELD_ID_PARAMETER, fieldId).asUrlString();
    }

    private String getScreensUrl(String fieldId, Long layoutId) {
        String url = new UrlBuilder(this.jiraBaseUrls.baseUrl().concat("/secure/admin/AssociateFieldToScreens!default.jspa")).addParameter(FIELD_ID_PARAMETER, fieldId).asUrlString();
        return url.concat(new UrlBuilder("&returnUrl=ConfigureFieldLayout!default.jspa").addParameter(ID_PARAMETER, (Object)layoutId).asUrlString());
    }

    private String getRendererUrl(String fieldId, Long layoutId) {
        return new UrlBuilder(this.jiraBaseUrls.baseUrl().concat("/secure/admin/EditFieldLayoutItemRenderer!default.jspa")).addParameter(FIELD_ID_PARAMETER, fieldId).addParameter(ID_PARAMETER, (Object)layoutId).asUrlString();
    }

    private FieldActionsBean createFieldActionsBean(FieldLayoutItem field, Long layoutId) {
        OrderableField orderableField = field.getOrderableField();
        boolean isFieldLocked = this.isFieldLocked((Field)orderableField);
        return new FieldActionsBean(!isFieldLocked ? new FieldActionBean("Edit", this.getEditUrl(orderableField.getId(), layoutId)) : null, !this.fieldManager.isUnscreenableField((Field)orderableField) ? new FieldActionBean("Screens", this.getScreensUrl(orderableField.getId(), layoutId)) : null, !isFieldLocked && this.isRenderable(orderableField) ? new FieldActionBean("Renderer", this.getRendererUrl(orderableField.getId(), layoutId)) : null);
    }

    private Long parseConfigId(Long configId) {
        return configId == -1L ? null : configId;
    }

    private EditableFieldLayout getFieldLayout(Long configId) {
        Long id = this.parseConfigId(configId);
        return id == null ? this.fieldLayoutManager.getEditableDefaultFieldLayout() : this.fieldLayoutManager.getEditableFieldLayout(id);
    }
}

