/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v2.clusterlock;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.beehive.core.ManagedClusterLockService;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.internal.v2.clusterlock.ClusterLockStatusesBean;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.Collection;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="clusterlock")
@Produces(value={"application/json"})
@SystemAdminOnly
public class ClusterLockResource {
    private final ManagedClusterLockService clusterLockService;
    private final GlobalPermissionManager permissionManager;
    private final JiraAuthenticationContext authenticationContext;

    @Inject
    public ClusterLockResource(ManagedClusterLockService clusterLockMonitoringProvider, GlobalPermissionManager permissionManager, JiraAuthenticationContext authenticationContext) {
        this.clusterLockService = clusterLockMonitoringProvider;
        this.permissionManager = permissionManager;
        this.authenticationContext = authenticationContext;
    }

    @GET
    @Operation(summary="Returns details of all cluster locks held by any node", description="Returns details of all cluster locks held by any node")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returned if the currently authenticated user can view cluster locks", content={@Content(schema=@Schema(implementation=ClusterLockStatusesBean.class), mediaType="application/json")}), @ApiResponse(responseCode="403", description="Returned if the currently authenticated user does not have permission to view cluster locks")})
    public Response get() {
        if (!this.permissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, this.authenticationContext.getLoggedInUser())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ErrorCollection.of(new String[0])).build();
        }
        Collection clusterLockStatuses = this.clusterLockService.getStatusesOfAllHeldClusterLocks();
        return Response.ok((Object)new ClusterLockStatusesBean(clusterLockStatuses)).cacheControl(CacheControl.never()).build();
    }
}

