/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v2.attachment;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.attachment.AttachmentService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/attachment-permission")
@LicensedOnly
public class AttachmentPermissionResource {
    private final JiraAuthenticationContext authenticationContext;
    private final ProjectManager projectManager;
    private final AttachmentService attachmentService;
    private static final Logger log = LoggerFactory.getLogger(AttachmentPermissionResource.class);

    @Inject
    public AttachmentPermissionResource(JiraAuthenticationContext authenticationContext, ProjectManager projectManager, AttachmentService attachmentService) {
        this.authenticationContext = authenticationContext;
        this.projectManager = projectManager;
        this.attachmentService = attachmentService;
    }

    @Path(value="attach")
    @GET
    @UnrestrictedAccess
    @Produces(value={"application/json"})
    public Response getCanAttach(@QueryParam(value="projectKey") String projectKey) {
        boolean canAttach = this.checkCanAttach(projectKey);
        return Response.ok((Object)canAttach).build();
    }

    private boolean checkCanAttach(String projectKey) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        Project project = this.projectManager.getProjectByCurrentKey(projectKey);
        if (project == null) {
            return false;
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        JiraServiceContextImpl context = new JiraServiceContextImpl(user, (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            log.error("Errors occurred while checking attachment permissions: {}", (Object)errorCollection);
            return false;
        }
        return this.attachmentService.canCreateAttachments((JiraServiceContext)context, project);
    }
}

