/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v2.archiving;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.event.issue.ArchivedIssueExportEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.archiving.ArchivedIssueSearchService;
import com.atlassian.jira.issue.archiving.ArchivingExportFinishedAnalyticsEvent;
import com.atlassian.jira.issue.archiving.ArchivingExportStartedAnalyticsEvent;
import com.atlassian.jira.issue.archiving.ArchivingIssuesFilteredAnalyticsEvent;
import com.atlassian.jira.issue.archiving.query.ArchiveQuery;
import com.atlassian.jira.issue.archiving.query.ArchivedIssue;
import com.atlassian.jira.issue.fields.AbstractField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.rest.internal.v2.archiving.bean.ArchivedIssuesBean;
import com.atlassian.jira.rest.internal.v2.archiving.bean.ArchivedIssuesCountBean;
import com.atlassian.jira.rest.v2.issue.IncludedFields;
import com.atlassian.jira.rest.v2.issue.IssueBean;
import com.atlassian.jira.rest.v2.issue.UserBeanBuilder;
import com.atlassian.jira.rest.v2.issue.builder.BeanBuilderFactory;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.encoder.CsvEncoder;
import org.supercsv.encoder.DefaultCsvEncoder;
import org.supercsv.io.CsvMapWriter;
import org.supercsv.prefs.CsvPreference;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="archiving")
@LicensedOnly
public class ArchivingResource {
    private static final Logger log = LoggerFactory.getLogger(ArchivingResource.class);
    private final JiraAuthenticationContext authenticationContext;
    private final GlobalPermissionManager globalPermissionManager;
    private final DateTimeFormatter dateTimeFormatter;
    private final BeanBuilderFactory beanBuilderFactory;
    private final ArchivedIssueSearchService archiveSearchService;
    private final JiraBaseUrls urls;
    private final EventPublisher eventPublisher;

    @Inject
    public ArchivingResource(JiraAuthenticationContext authenticationContext, GlobalPermissionManager globalPermissionManager, @ComponentImport ArchivedIssueSearchService archiveSearchService, DateTimeFormatter dateTimeFormatter, JiraBaseUrls urls, BeanBuilderFactory beanBuilderFactory, EventPublisher eventPublisher) {
        this.authenticationContext = authenticationContext;
        this.globalPermissionManager = globalPermissionManager;
        this.dateTimeFormatter = dateTimeFormatter;
        this.beanBuilderFactory = beanBuilderFactory;
        this.archiveSearchService = archiveSearchService;
        this.urls = urls;
        this.eventPublisher = eventPublisher;
    }

    @Produces(value={"text/csv"})
    @GET
    public Response download(@QueryParam(value="maxResults") int maxResults, @QueryParam(value="projectKey") List<String> projectKeys, @QueryParam(value="reporter") List<String> reporters, @QueryParam(value="issueType") List<String> issueTypes, @QueryParam(value="archivedBy") List<String> archivedBy, @QueryParam(value="archivedBefore") Long archivedBefore, @QueryParam(value="archivedAfter") Long archivedAfter) {
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, this.authenticationContext.getLoggedInUser())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return this.queryArchive(projectKeys, reporters, issueTypes, archivedBy, archivedBefore, archivedAfter, maxResults, this::downloadCsv);
    }

    @GET
    @Path(value="count")
    public Response getArchivedIssuesCount() {
        ArchivedIssueSearchService.ArchiveSearchRequest request = new ArchivedIssueSearchService.ArchiveSearchRequest();
        ArchivedIssueSearchService.ValidationResult validationResult = this.archiveSearchService.validateSearch(request);
        if (!validationResult.isValid()) {
            ErrorCollection.Reason reason = ErrorCollection.Reason.getWorstReason((Collection)validationResult.getErrorCollection().getReasons());
            log.error(validationResult.getErrorCollection().toString());
            if (reason == null) {
                reason = ErrorCollection.Reason.SERVER_ERROR;
            }
            return Response.status((int)reason.getHttpStatusCode()).build();
        }
        int total = this.archiveSearchService.count(validationResult);
        return Response.ok((Object)new ArchivedIssuesCountBean(total)).build();
    }

    @GET
    @Path(value="browse")
    public Response getArchivedIssues(@QueryParam(value="maxResults") int maxResults, @QueryParam(value="projectKey") List<String> projectKeys, @QueryParam(value="reporter") List<String> reporters, @QueryParam(value="issueType") List<String> issueTypes, @QueryParam(value="archivedBy") List<String> archivedBy, @QueryParam(value="archivedBefore") Long archivedBefore, @QueryParam(value="archivedAfter") Long archivedAfter) {
        return this.queryArchive(projectKeys, reporters, issueTypes, archivedBy, archivedBefore, archivedAfter, maxResults, validationResult -> {
            int total;
            List<IssueBean> issueBeanList;
            try (Stream archivedIssueStream = this.archiveSearchService.search(validationResult);){
                issueBeanList = archivedIssueStream.map(archivedIssue -> {
                    IssueBean bean = this.beanBuilderFactory.newIssueBeanBuilder2(this.getFieldsToBeIncluded(), null).build(archivedIssue.getIssue());
                    this.addField(bean, "archivedBy", new JsonData((Object)UserBeanBuilder.shortBuilder(this.urls).user(archivedIssue.getArchivedBy()).buildShort()));
                    this.addField(bean, "archivedDate", new JsonData((Object)this.formatTimestamp(archivedIssue.getArchivedDate())));
                    this.addField(bean, "projectArchived", new JsonData((Object)archivedIssue.getIssue().getProjectObject().isArchived()));
                    return bean;
                }).collect(Collectors.toList());
            }
            int n = total = issueBeanList.size() < maxResults ? issueBeanList.size() : this.archiveSearchService.count(validationResult);
            if (!validationResult.getQuery().isEmpty()) {
                this.eventPublisher.publish((Object)new ArchivingIssuesFilteredAnalyticsEvent(projectKeys, reporters, issueTypes, archivedBy, archivedBefore, archivedAfter, Integer.valueOf(total)));
            }
            return Response.ok((Object)new ArchivedIssuesBean(issueBeanList, total)).build();
        });
    }

    private Response queryArchive(List<String> projectKeys, List<String> reporters, List<String> issueTypes, List<String> archivedBy, Long archivedBefore, Long archivedAfter, int maxResults, Function<ArchivedIssueSearchService.ValidationResult, Response> consumer) {
        ArchivedIssueSearchService.ArchiveSearchRequest request = new ArchivedIssueSearchService.ArchiveSearchRequest().setArchivedAfter(archivedAfter).setArchivedBefore(archivedBefore).setArchivedBy(archivedBy).setIssueType(issueTypes).setProjectKeyOrId(projectKeys).setReporter(reporters).setMaxResults(maxResults);
        ArchivedIssueSearchService.ValidationResult validation = this.archiveSearchService.validateSearch(request);
        if (!validation.isValid()) {
            log.error(validation.getErrorCollection().toString());
            ErrorCollection.Reason reason = ErrorCollection.Reason.getWorstReason((Collection)validation.getErrorCollection().getReasons());
            if (reason == null) {
                reason = ErrorCollection.Reason.SERVER_ERROR;
            }
            return Response.status((int)reason.getHttpStatusCode()).build();
        }
        return consumer.apply(validation);
    }

    private void addField(IssueBean bean, String fieldName, JsonData value) {
        bean.addField((Field)new AbstractField(fieldName, fieldName, this.authenticationContext), new FieldJsonRepresentation(value), true);
    }

    private IncludedFields getFieldsToBeIncluded() {
        return IncludedFields.nothingIncludedByDefault(Collections.singletonList(StringList.fromList("id", "key", "archivedBy", "archivedDate", "issuetype", "project", "projectArchived", "status", "reporter", "assignee", "created", "resolutiondate", "summary")));
    }

    private String getContentDispositionValue(String fileName, Date creationDate) {
        String httpDate = this.dateTimeFormatter.withStyle(DateTimeStyle.RFC_1123_DATE_TIME).format(creationDate);
        return "attachment; filename=\"" + fileName + "\"; creation-date=\"" + httpDate + "\"";
    }

    private Response downloadCsv(ArchivedIssueSearchService.ValidationResult validationResult) {
        ArchiveQuery query = validationResult.getQuery();
        Date now = new Date();
        String nowFormatted = this.dateTimeFormatter.withStyle(DateTimeStyle.ISO_8601_DATE_TIME).format(now);
        List projectsKeys = query.getProjects().stream().map(Project::getKey).collect(Collectors.toList());
        String fileName = String.format("Archived Issues Export%s %s.csv", projectsKeys.stream().reduce(" ", (p1, p2) -> p1 + " " + p2), nowFormatted);
        return Response.ok(output -> this.streamCsv(validationResult, output, projectsKeys)).type("text/csv").header("Content-Disposition", (Object)this.getContentDispositionValue(fileName, now)).cacheControl(this.privately()).build();
    }

    private CacheControl privately() {
        CacheControl cacheForever = new CacheControl();
        cacheForever.setPrivate(true);
        cacheForever.setMustRevalidate(true);
        return cacheForever;
    }

    private void streamCsv(ArchivedIssueSearchService.ValidationResult validationResult, OutputStream output, List<String> projectsKeys) throws IOException {
        ArchiveQuery query = validationResult.getQuery();
        this.eventPublisher.publish((Object)new ArchivingExportStartedAnalyticsEvent(query.getProjects().stream().map(Project::getId).collect(Collectors.toList()), Integer.valueOf(query.getMaxResults())));
        CsvMapWriter pw = new CsvMapWriter((Writer)new BufferedWriter(new OutputStreamWriter(output, "UTF-8")), new CsvPreference.Builder(CsvPreference.EXCEL_PREFERENCE).useEncoder((CsvEncoder)new DefaultCsvEncoder()).build());
        String[] header = new String[]{this.getText("issue.archived.export.column.id"), this.getText("issue.archived.export.column.project"), this.getText("issue.archived.export.column.key"), this.getText("issue.archived.export.column.url"), this.getText("issue.archived.export.column.issuetype"), this.getText("issue.archived.export.column.status"), this.getText("issue.archived.export.column.creator"), this.getText("issue.archived.export.column.reporter"), this.getText("issue.archived.export.column.assignee"), this.getText("issue.archived.export.column.archivedby"), this.getText("issue.archived.export.column.archiveddate"), this.getText("issue.archived.export.column.summary"), this.getText("issue.archived.export.column.description"), this.getText("issue.archived.export.column.archivedstate")};
        pw.writeHeader(header);
        pw.flush();
        log.info("Stream archived issues");
        long issuesTotal = 0L;
        try (Stream stream = this.archiveSearchService.search(validationResult);){
            Iterator iterator = stream.iterator();
            while (iterator.hasNext()) {
                ArchivedIssue issue = (ArchivedIssue)iterator.next();
                this.printIssue(pw, header, issue);
                ++issuesTotal;
            }
        }
        log.info("Flush");
        pw.flush();
        this.eventPublisher.publish((Object)new ArchivedIssueExportEvent(issuesTotal, projectsKeys));
        this.eventPublisher.publish((Object)new ArchivingExportFinishedAnalyticsEvent());
    }

    private void printIssue(CsvMapWriter pw, String[] header, ArchivedIssue archivedIssue) {
        Issue issue = archivedIssue.getIssue();
        HashMap<String, String> csvValues = new HashMap<String, String>();
        csvValues.put(header[0], String.valueOf(issue.getId()));
        csvValues.put(header[1], issue.getProjectObject().getName());
        csvValues.put(header[2], issue.getKey());
        csvValues.put(header[3], this.getIssueUrl(issue.getKey()));
        csvValues.put(header[4], issue.getIssueType().getName());
        csvValues.put(header[5], issue.getStatus().getName());
        csvValues.put(header[6], this.getUserName(issue.getCreator()));
        csvValues.put(header[7], this.getUserName(issue.getReporter()));
        csvValues.put(header[8], this.getUserName(issue.getAssignee()));
        csvValues.put(header[9], this.getUserName(archivedIssue.getArchivedBy()));
        csvValues.put(header[10], this.formatTimestamp(archivedIssue.getArchivedDate()));
        csvValues.put(header[11], issue.getSummary());
        csvValues.put(header[12], issue.getDescription());
        csvValues.put(header[13], this.getText(archivedIssue.getArchivedState().getName()));
        try {
            pw.write(csvValues, header);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getUserName(ApplicationUser user) {
        if (user == null) {
            return "-";
        }
        return user.getName();
    }

    private String formatTimestamp(Timestamp timestamp) {
        if (timestamp == null) {
            return "-";
        }
        return this.dateTimeFormatter.forLoggedInUser().withStyle(DateTimeStyle.ISO_8601_DATE_TIME).format((Date)timestamp);
    }

    private String getText(String s) {
        return this.authenticationContext.getI18nHelper().getText(s);
    }

    private String getIssueUrl(String issueKey) {
        return this.urls.baseUrl() + "/browse/" + issueKey;
    }
}

