/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v2;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.user.GroupView;
import com.atlassian.jira.bc.user.UserApplicationHelper;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.util.UpdateUserApplicationHelper;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="viewuser")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@LicensedOnly
public class ViewUserResource {
    private final UpdateUserApplicationHelper updateUserApplicationHelper;
    private final ResponseFactory responseFactory;
    private final UserApplicationHelper userApplicationHelper;
    private final JiraAuthenticationContext authContext;
    private final GlobalPermissionManager permissionManager;
    private final UserManager userManager;
    private final ApplicationRoleManager applicationRoleManager;
    private static final Function<ApplicationRole, ApplicationKey> TO_APPLICATION_KEY = new Function<ApplicationRole, ApplicationKey>(){

        @Nullable
        public ApplicationKey apply(@Nullable ApplicationRole input) {
            if (input == null) {
                return null;
            }
            return input.getKey();
        }
    };

    @Inject
    public ViewUserResource(UpdateUserApplicationHelper updateUserApplicationHelper, ResponseFactory responseFactory, @ComponentImport UserApplicationHelper userApplicationHelper, JiraAuthenticationContext authContext, GlobalPermissionManager permissionManager, UserManager userManager, ApplicationRoleManager applicationRoleManager) {
        this.updateUserApplicationHelper = updateUserApplicationHelper;
        this.responseFactory = responseFactory;
        this.userApplicationHelper = userApplicationHelper;
        this.authContext = authContext;
        this.permissionManager = permissionManager;
        this.userManager = userManager;
        this.applicationRoleManager = applicationRoleManager;
    }

    @DELETE
    @Path(value="application/{applicationKey}")
    public Response removeUserFromApplication(@QueryParam(value="username") String username, @PathParam(value="applicationKey") String applicationKey) {
        UpdateUserApplicationHelper.ApplicationUpdateResult applicationUpdateResult = this.updateUserApplicationHelper.removeUserFromApplication(username, applicationKey);
        UserApplicationUpdateBean userApplicationUpdateBean = this.getUserApplicationUpdateBeanFromUpdateResult(applicationUpdateResult);
        if (applicationUpdateResult.isValid()) {
            return this.responseFactory.okNoCache(userApplicationUpdateBean);
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).entity((Object)userApplicationUpdateBean).build();
    }

    @POST
    @Path(value="application/{applicationKey}")
    public Response addUserToApplication(@QueryParam(value="username") String username, @PathParam(value="applicationKey") String applicationKey) {
        UpdateUserApplicationHelper.ApplicationUpdateResult applicationUpdateResult = this.updateUserApplicationHelper.addUserToApplication(username, applicationKey);
        UserApplicationUpdateBean userApplicationUpdateBean = this.getUserApplicationUpdateBeanFromUpdateResult(applicationUpdateResult);
        if (applicationUpdateResult.isValid()) {
            return this.responseFactory.okNoCache(userApplicationUpdateBean);
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).entity((Object)userApplicationUpdateBean).build();
    }

    private UserApplicationUpdateBean getUserApplicationUpdateBeanFromUpdateResult(UpdateUserApplicationHelper.ApplicationUpdateResult applicationUpdateResult) {
        return new UserApplicationUpdateBean((List<String>)ImmutableList.copyOf((Collection)applicationUpdateResult.getErrorCollection().getErrorMessages()), this.isUserAccessEditable(applicationUpdateResult), this.getApplicationForUser(applicationUpdateResult), this.getUserGroups(applicationUpdateResult), this.getUserDisplayName(applicationUpdateResult), this.isShowNoAppsWarning(applicationUpdateResult));
    }

    private List<UserApplicationHelper.ApplicationSelection> getApplicationForUser(@Nonnull UpdateUserApplicationHelper.ApplicationUpdateResult applicationUpdateResult) {
        Option<ApplicationUser> applicationUser = applicationUpdateResult.getApplicationUser();
        if (applicationUser.isEmpty()) {
            return ImmutableList.of();
        }
        return this.userApplicationHelper.getApplicationsForUser((ApplicationUser)applicationUser.get());
    }

    private List<GroupView> getUserGroups(@Nonnull UpdateUserApplicationHelper.ApplicationUpdateResult applicationUpdateResult) {
        if (applicationUpdateResult.getApplicationUser().isEmpty()) {
            return ImmutableList.of();
        }
        return this.userApplicationHelper.getUserGroups((ApplicationUser)applicationUpdateResult.getApplicationUser().get());
    }

    private boolean isUserAccessEditable(@Nonnull UpdateUserApplicationHelper.ApplicationUpdateResult applicationUpdateResult) {
        ApplicationUser loggedInUser = this.authContext.getLoggedInUser();
        Option<ApplicationUser> userOption = applicationUpdateResult.getApplicationUser();
        ApplicationUser user = (ApplicationUser)userOption.getOrNull();
        return userOption.isDefined() && loggedInUser != null && this.userManager.canUpdateGroupMembershipForUser(user) && (this.permissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, loggedInUser) || !this.permissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user));
    }

    private String getUserDisplayName(@Nonnull UpdateUserApplicationHelper.ApplicationUpdateResult applicationUpdateResult) {
        if (applicationUpdateResult.getApplicationUser().isEmpty()) {
            return "";
        }
        return ((ApplicationUser)applicationUpdateResult.getApplicationUser().get()).getDisplayName();
    }

    private boolean isShowNoAppsWarning(@Nonnull UpdateUserApplicationHelper.ApplicationUpdateResult applicationUpdateResult) {
        return !this.userApplicationHelper.canUserLogin((ApplicationUser)applicationUpdateResult.getApplicationUser().getOrNull());
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    public static class UserApplicationUpdateBean {
        private List<String> errorMessages;
        private boolean isEditable;
        private List<UserApplicationHelper.ApplicationSelection> selectableApplications;
        private List<GroupView> userGroups;
        private String displayName;
        private boolean showNoAppsWarning;

        public UserApplicationUpdateBean() {
        }

        public UserApplicationUpdateBean(List<String> errorMessages, boolean isEditable, List<UserApplicationHelper.ApplicationSelection> selectableApplications, List<GroupView> userGroups, String displayName, boolean showNoAppsWarning) {
            this.errorMessages = errorMessages;
            this.isEditable = isEditable;
            this.selectableApplications = selectableApplications;
            this.userGroups = userGroups;
            this.displayName = displayName;
            this.showNoAppsWarning = showNoAppsWarning;
        }

        public boolean isShowNoAppsWarning() {
            return this.showNoAppsWarning;
        }

        public List<String> getErrorMessages() {
            return this.errorMessages;
        }

        public boolean isEditable() {
            return this.isEditable;
        }

        public List<UserApplicationHelper.ApplicationSelection> getSelectableApplications() {
            return this.selectableApplications;
        }

        public List<GroupView> getUserGroups() {
            return this.userGroups;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

