/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v1;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.jira.license.LicenseBannerHelper;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Path(value="licensebanner")
@LicensedOnly
public class LicenseBannerResource {
    private final LicenseBannerHelper helper;

    @Inject
    public LicenseBannerResource(LicenseBannerHelper helper) {
        this.helper = helper;
    }

    @POST
    @Path(value="remindlater")
    public Response remindMeLater() {
        this.helper.remindMeLater();
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @Path(value="remindlater")
    public Response removeRemindMeLater() {
        this.helper.clearRemindMe();
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="markup")
    public Response getLicenseDetails() throws JSONException {
        JSONObject licenseMarkups = new JSONObject();
        licenseMarkups.put("bannerMarkup", (Object)this.helper.getExpiryBanner());
        licenseMarkups.put("flagMarkup", (Object)this.helper.getLicenseFlag());
        return Response.ok().entity((Object)licenseMarkups.toString()).cacheControl(CacheControl.never()).build();
    }
}

