/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.dashboard.JiraWhitelist;
import com.atlassian.jira.issue.SelfUrlOriginType;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.SelfUrlOriginTypeUtil;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.sal.api.user.UserKey;
import java.io.IOException;
import java.net.URI;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@UnrestrictedAccess
public class DenyRequestWithNotAllowedHostHeaderFilter
extends AbstractHttpFilter {
    private final JiraWhitelist jiraWhitelist = (JiraWhitelist)ComponentAccessor.getComponent(JiraWhitelist.class);
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final JiraAuthenticationContext authenticationContext;
    private final ApplicationProperties applicationProperties;

    public DenyRequestWithNotAllowedHostHeaderFilter(VelocityRequestContextFactory velocityRequestContextFactory, JiraAuthenticationContext authenticationContext, ApplicationProperties applicationProperties) {
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.authenticationContext = authenticationContext;
        this.applicationProperties = applicationProperties;
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        UserKey userKey;
        URI canonicalBaseUrl;
        String selfUrlOriginType = SelfUrlOriginTypeUtil.getOrDefaultSelfUrlOriginType((ApplicationProperties)this.applicationProperties);
        if (selfUrlOriginType.equals(SelfUrlOriginType.ALLOW_LIST.name()) && !this.jiraWhitelist.allows(canonicalBaseUrl = URI.create(this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl()), userKey = new UserKey(this.authenticationContext.getLoggedInUser().getKey()))) {
            response.sendError(400, "The request host is not in the allowlist.");
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

