/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.filter;

import java.io.IOException;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
class CacheControlResponseFilter
implements ContainerResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(CacheControlResponseFilter.class);

    @Inject
    public CacheControlResponseFilter() {
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        MultivaluedMap headers = responseContext.getHeaders();
        if (!headers.containsKey((Object)"Cache-Control") && !headers.containsKey((Object)"Expires")) {
            log.trace("Response does not have caching headers, adding 'Cache-Control: no-cache, no-store'");
            headers.putSingle((Object)"Cache-Control", (Object)"no-cache, no-store, no-transform");
        }
    }
}

