/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.factory;

import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.factory.ErrorCollectionFactory;
import com.atlassian.jira.util.ErrorCollection;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Responder {
    private final ErrorCollectionFactory errorCollectionFactory;

    @Autowired
    Responder(ErrorCollectionFactory errorCollectionFactory) {
        this.errorCollectionFactory = errorCollectionFactory;
    }

    public Response errors(com.atlassian.jira.util.ErrorCollection errors) {
        ErrorCollection restfulErrors = this.errorCollectionFactory.of(errors);
        return this.restfulErrors(restfulErrors);
    }

    public Response restfulErrors(ErrorCollection errors) {
        int status = errors.getStatus();
        return Response.status((int)status).entity((Object)errors).cacheControl(CacheControl.never()).build();
    }

    public Response successfulDelete() {
        return this.builder(Response.Status.NO_CONTENT).build();
    }

    public Response.ResponseBuilder builder(Response.Status status) {
        return Response.status((Response.Status)status);
    }

    public Response exception(Exception exception) {
        ErrorCollection errors = this.errorCollectionFactory.of(ErrorCollection.Reason.SERVER_ERROR, exception.getMessage());
        return this.restfulErrors(errors);
    }
}

