/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.exception;

import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import java.util.Collections;
import java.util.UUID;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JiraExceptionMapper<E extends Throwable>
implements ExceptionMapper<E> {
    private static final Logger log = LoggerFactory.getLogger(JiraExceptionMapper.class);

    public Response toResponse(E exception) {
        String errorId = UUID.randomUUID().toString();
        String message = ((Throwable)exception).getMessage() + " [" + errorId + "]";
        log.error("Uncaught exception {} thrown by service: {}", new Object[]{errorId, ((Throwable)exception).getMessage(), exception});
        JSONObject json = new JSONObject();
        try {
            json.put("errorMessages", Collections.singletonList(message));
        }
        catch (JSONException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).cacheControl(CacheControl.never()).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)json.toString()).type(MediaType.APPLICATION_JSON_TYPE).cacheControl(CacheControl.never()).build();
    }
}

