/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.auth;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.security.websudo.InternalWebSudoManager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="websudo")
@Consumes(value={"application/json"})
@LicensedOnly
public class WebSudo {
    private final InternalWebSudoManager internalWebSudoManager;

    @Inject
    public WebSudo(InternalWebSudoManager internalWebSudoManager) {
        this.internalWebSudoManager = internalWebSudoManager;
    }

    @DELETE
    @Operation(summary="Invalidate the current WebSudo session", description="This method invalidates the any current WebSudo session.")
    @RequestBody(description="No request body is needed", content={@Content(schema=@Schema(implementation=String.class))})
    @ApiResponse(responseCode="204", description="Returned if no error occurs")
    public Response release(@Context HttpServletRequest servletRequest, @Context HttpServletResponse servletResponse) {
        this.internalWebSudoManager.invalidateSession(servletRequest, servletResponse);
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }
}

