/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.auth;

import com.atlassian.jira.rest.bind.DateTimeAdapter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="loginInfo")
class LoginInfo {
    @XmlElement
    @Schema(example="10")
    public Long failedLoginCount;
    @XmlElement
    @Schema(example="127")
    public Long loginCount;
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    @XmlElement
    @Schema(example="2015-08-12T12:45:00.000+0000")
    public Date lastFailedLoginTime;
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    @XmlElement
    @Schema(example="2015-08-12T12:45:00.000+0000")
    public Date previousLoginTime;

    public LoginInfo(com.atlassian.jira.bc.security.login.LoginInfo loginInfo) {
        Long previousLoginTime;
        this.failedLoginCount = loginInfo.getTotalFailedLoginCount();
        this.loginCount = loginInfo.getLoginCount();
        Long failedLoginTime = loginInfo.getLastFailedLoginTime();
        if (failedLoginTime != null) {
            this.lastFailedLoginTime = new Date(failedLoginTime);
        }
        if ((previousLoginTime = loginInfo.getPreviousLoginTime()) != null) {
            this.previousLoginTime = new Date(previousLoginTime);
        }
    }

    LoginInfo() {
    }
}

