/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.api.util;

import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ErrorCollections;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Either;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class ExpandParameterParser<T extends Enum<T>> {
    private static final Splitter SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private final I18nHelper i18n;
    private final Map<String, T> index;
    private final List<T> values;

    protected ExpandParameterParser(I18nHelper i18n, Class<T> enumClass) {
        this.i18n = i18n;
        this.index = this.buildIndex(enumClass);
        this.values = ImmutableList.copyOf(Arrays.asList((Enum[])enumClass.getEnumConstants()));
    }

    private Map<String, T> buildIndex(Class<T> enumClass) {
        ImmutableMap.Builder indexBuilder = ImmutableMap.builder();
        for (Enum constant : (Enum[])enumClass.getEnumConstants()) {
            indexBuilder.put((Object)constant.name(), (Object)constant);
        }
        return indexBuilder.build();
    }

    public Either<ErrorCollection, List<T>> parseExpandQuery(@Nullable String expandQueryParameter) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (String elementStr : SPLITTER.split((CharSequence)Strings.nullToEmpty((String)expandQueryParameter))) {
            if (!this.index.containsKey(elementStr)) {
                return Either.left((Object)ErrorCollections.create((String)this.i18n.getText("rest.error.invalid.expand", elementStr, this.values.toString()), (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED));
            }
            resultBuilder.add((Object)((Enum)this.index.get(elementStr)));
        }
        return Either.right((Object)resultBuilder.build());
    }
}

