/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.api.project;

import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.user.ApplicationUser;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.URI;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="projectRoleActor")
public class RoleActorBean {
    @XmlElement
    @Schema(example="10360")
    Long id;
    @XmlElement
    @Schema(example="Developers")
    String displayName;
    @XmlElement
    @Schema(example="atlassian-group-role-actor")
    String type;
    @XmlElement
    @Schema(example="jira-developers")
    String name;
    @XmlElement
    @Schema(example="http://www.example.com/jira/rest/api/2/user?username=fred")
    URI avatarUrl;

    public static RoleActorBean convert(RoleActor actor) {
        ApplicationUser user;
        RoleActorBean bean = new RoleActorBean();
        bean.id = actor.getId();
        bean.displayName = actor.getDescriptor();
        bean.type = actor.getType();
        bean.name = actor.getType().equals("atlassian-user-role-actor") ? ((user = (ApplicationUser)actor.getUsers().iterator().next()) == null ? "" : user.getName()) : actor.getParameter();
        return bean;
    }

    public String getName() {
        return this.name;
    }

    public void setAvatarUrl(URI avatarUrl) {
        this.avatarUrl = avatarUrl;
    }
}

