/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.api.issue;

import com.atlassian.jira.rest.api.issue.IssueFields;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class FieldsSerializer
extends JsonSerializer<IssueFields> {
    public void serialize(IssueFields issueFields, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (issueFields != null) {
            jgen.writeStartObject();
            this.serializeSystemFields(issueFields, jgen, provider);
            this.serializeCustomFields(issueFields, jgen);
            jgen.writeEndObject();
        }
    }

    protected void serializeSystemFields(IssueFields issueFields, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        for (Field field : issueFields.getClass().getFields()) {
            JsonProperty jsonAnnotation = field.getAnnotation(JsonProperty.class);
            if (!FieldsSerializer.isPublic(field) && jsonAnnotation == null) continue;
            try {
                Object fieldValue = field.get(issueFields);
                if (fieldValue == null) continue;
                String overrideName = jsonAnnotation != null ? jsonAnnotation.value() : null;
                String jsonName = !StringUtils.isEmpty((CharSequence)overrideName) ? overrideName : field.getName();
                provider.defaultSerializeField(jsonName, fieldValue, jgen);
            }
            catch (IllegalAccessException e) {
                throw new JsonGenerationException("Error reading field '" + field.getName() + "'", (Throwable)e);
            }
        }
    }

    private void serializeCustomFields(IssueFields issueFields, JsonGenerator jgen) throws IOException {
        if (issueFields.fields != null) {
            for (Map.Entry<String, Object> customField : issueFields.fields.entrySet()) {
                Object value = customField.getValue();
                if (value instanceof String) {
                    jgen.writeStringField(customField.getKey(), (String)customField.getValue());
                    continue;
                }
                if (value instanceof Array) {
                    jgen.writeArrayFieldStart(customField.getKey());
                    for (String string : (String[])value) {
                        jgen.writeString(string);
                    }
                    jgen.writeEndArray();
                    continue;
                }
                jgen.writeObjectField(customField.getKey(), customField.getValue());
            }
        }
    }

    protected static boolean isPublic(Field field) {
        return (field.getModifiers() & 1) != 0;
    }
}

