/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.dashboard;

import com.atlassian.gadgets.opensocial.spi.Whitelist;
import com.atlassian.jira.bc.whitelist.OutboundWhitelistProvider;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.sal.api.user.UserKey;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;

public class JiraWhitelist
implements Whitelist {
    private final ApplicationProperties props;
    private final OutboundWhitelistProvider outboundWhitelistProvider;

    public JiraWhitelist(ApplicationProperties props, OutboundWhitelistProvider outboundWhitelistProvider) {
        this.props = props;
        this.outboundWhitelistProvider = outboundWhitelistProvider;
    }

    public boolean allows(URI uriRequest, UserKey userKey) {
        String canonicalBaseUrl = this.props.getText("jira.baseurl");
        try {
            URI uri = new URI(uriRequest.normalize().toASCIIString());
            URI baseUri = new URI(canonicalBaseUrl);
            boolean isLocal = StringUtils.equalsIgnoreCase((CharSequence)baseUri.getScheme(), (CharSequence)uri.getScheme()) && StringUtils.equalsIgnoreCase((CharSequence)baseUri.getHost(), (CharSequence)uri.getHost()) && baseUri.getPort() == uri.getPort();
            return isLocal || this.outboundWhitelistProvider.getOutboundWhitelist().isAllowed(uri, userKey);
        }
        catch (NullPointerException | URISyntaxException e) {
            return false;
        }
    }
}

