/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.dashboard;

import com.atlassian.gadgets.DashboardItemState;
import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.dashboard.DashboardState;
import com.atlassian.gadgets.dashboard.spi.DashboardStateStoreException;
import com.atlassian.gadgets.dashboard.spi.GadgetLayout;
import com.atlassian.gadgets.dashboard.spi.changes.AddGadgetChange;
import com.atlassian.gadgets.dashboard.spi.changes.DashboardChange;
import com.atlassian.gadgets.dashboard.spi.changes.GadgetColorChange;
import com.atlassian.gadgets.dashboard.spi.changes.RemoveGadgetChange;
import com.atlassian.gadgets.dashboard.spi.changes.UpdateGadgetUserPrefsChange;
import com.atlassian.gadgets.dashboard.spi.changes.UpdateLayoutChange;
import com.atlassian.jira.dashboard.DashboardItemStateConverter;
import com.atlassian.jira.dashboard.DashboardUtil;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.portal.PortalPageStore;
import com.atlassian.jira.portal.PortletConfiguration;
import com.atlassian.jira.portal.PortletConfigurationStore;
import io.atlassian.fugue.Iterables;
import java.util.List;

class JiraDashboardChangeHandler
implements DashboardChange.Visitor {
    private final DashboardState updateDashboardState;
    private final PortletConfigurationStore portletConfigurationStore;
    private final PortalPageStore portalPageStore;

    JiraDashboardChangeHandler(DashboardState updateDashboardState, PortletConfigurationStore portletConfigurationStore, PortalPageStore portalPageStore) {
        this.updateDashboardState = updateDashboardState;
        this.portletConfigurationStore = portletConfigurationStore;
        this.portalPageStore = portalPageStore;
    }

    public void accept(Iterable<DashboardChange> changes) {
        for (DashboardChange change : changes) {
            change.accept((DashboardChange.Visitor)this);
        }
    }

    public void visit(AddGadgetChange addGadgetChange) {
        DashboardState.ColumnIndex column = addGadgetChange.getColumnIndex();
        List dashboardItems = this.updateDashboardState.getDashboardColumns().getItemsInColumn(column);
        DashboardItemState newItemState = addGadgetChange.getDashboardItemState();
        DashboardItemStateConverter dashboardItemStateConverter = new DashboardItemStateConverter();
        PortletConfiguration pc = dashboardItemStateConverter.toPortletConfiguration(newItemState, DashboardUtil.toLong(this.updateDashboardState.getId()), column.index(), addGadgetChange.getRowIndex());
        this.portletConfigurationStore.addDashboardItem(pc.getDashboardPageId(), pc.getId(), pc.getColumn(), pc.getRow(), pc.getOpenSocialSpecUri(), pc.getColor(), pc.getUserPrefs(), pc.getCompleteModuleKey());
        this.moveDashboardItemsOnePositionDown(dashboardItems, addGadgetChange.getRowIndex() + 1, column.index());
    }

    public void visit(GadgetColorChange gadgetColorChange) {
        Long gadgetId = DashboardUtil.toLong(gadgetColorChange.getGadgetId());
        PortletConfiguration portletConfiguration = this.portletConfigurationStore.getByPortletId(gadgetId);
        if (portletConfiguration == null) {
            throw new DashboardStateStoreException("Gadget with id '" + gadgetColorChange.getGadgetId() + "' not found for color change.");
        }
        this.portletConfigurationStore.updateGadgetColor(gadgetId, gadgetColorChange.getColor());
    }

    public void visit(RemoveGadgetChange removeGadgetChange) {
        PortletConfiguration gadgetToRemove = this.portletConfigurationStore.getByPortletId(DashboardUtil.toLong(removeGadgetChange.getGadgetId()));
        List gadgets = this.updateDashboardState.getDashboardColumns().getItemsInColumn(DashboardState.ColumnIndex.from((int)gadgetToRemove.getColumn()));
        this.portletConfigurationStore.delete(gadgetToRemove);
        int row = 0;
        for (DashboardItemState gadget : gadgets) {
            this.portletConfigurationStore.updateGadgetPosition(DashboardUtil.toLong(gadget.getId()), row, gadgetToRemove.getColumn().intValue(), DashboardUtil.toLong(this.updateDashboardState.getId()));
            ++row;
        }
    }

    public void visit(UpdateGadgetUserPrefsChange updateGadgetUserPrefsChange) {
        this.portletConfigurationStore.updateUserPrefs(DashboardUtil.toLong(updateGadgetUserPrefsChange.getGadgetId()), updateGadgetUserPrefsChange.getPrefValues());
    }

    public void visit(UpdateLayoutChange updateLayoutChange) {
        Long dashboardId = DashboardUtil.toLong(this.updateDashboardState.getId());
        PortalPage portalPage = this.portalPageStore.getPortalPage(dashboardId);
        if (!portalPage.getLayout().equals((Object)updateLayoutChange.getLayout())) {
            this.portalPageStore.update(PortalPage.portalPage((PortalPage)portalPage).layout(updateLayoutChange.getLayout()).build());
        }
        GadgetLayout newLayout = updateLayoutChange.getGadgetLayout();
        for (int column = 0; column < newLayout.getNumberOfColumns(); ++column) {
            int row = 0;
            Iterable gadgets = newLayout.getGadgetsInColumn(column);
            for (GadgetId gadgetId : gadgets) {
                Long gadgetIdLong = DashboardUtil.toLong(gadgetId);
                PortletConfiguration portletConfiguration = this.portletConfigurationStore.getByPortletId(gadgetIdLong);
                if (portletConfiguration.getColumn() != column || portletConfiguration.getRow() != row) {
                    this.portletConfigurationStore.updateGadgetPosition(gadgetIdLong, row, column, dashboardId);
                }
                ++row;
            }
        }
    }

    private void moveDashboardItemsOnePositionDown(Iterable<DashboardItemState> dashboardItems, int firstNewRow, int column) {
        Long dashboardId = DashboardUtil.toLong(this.updateDashboardState.getId());
        Iterable itemsBelowNewItem = Iterables.drop((int)firstNewRow, dashboardItems);
        int row = firstNewRow;
        for (DashboardItemState dashboardItemState : itemsBelowNewItem) {
            this.portletConfigurationStore.updateGadgetPosition(DashboardUtil.toLong(dashboardItemState.getId()), row, column, dashboardId);
            ++row;
        }
    }
}

