/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.async;

import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.jira.rest.client.MetadataRestClient;
import com.atlassian.jira.rest.client.domain.IssueType;
import com.atlassian.jira.rest.client.domain.IssuelinksType;
import com.atlassian.jira.rest.client.domain.Priority;
import com.atlassian.jira.rest.client.domain.Resolution;
import com.atlassian.jira.rest.client.domain.ServerInfo;
import com.atlassian.jira.rest.client.domain.Status;
import com.atlassian.jira.rest.client.internal.async.AbstractAsynchronousRestClient;
import com.atlassian.jira.rest.client.internal.json.GenericJsonArrayParser;
import com.atlassian.jira.rest.client.internal.json.IssueLinkTypesJsonParser;
import com.atlassian.jira.rest.client.internal.json.IssueTypeJsonParser;
import com.atlassian.jira.rest.client.internal.json.PriorityJsonParser;
import com.atlassian.jira.rest.client.internal.json.ResolutionJsonParser;
import com.atlassian.jira.rest.client.internal.json.ServerInfoJsonParser;
import com.atlassian.jira.rest.client.internal.json.StatusJsonParser;
import com.atlassian.util.concurrent.Promise;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;

public class AsynchronousMetadataRestClient
extends AbstractAsynchronousRestClient
implements MetadataRestClient {
    private static final String SERVER_INFO_RESOURCE = "/serverInfo";
    private final ServerInfoJsonParser serverInfoJsonParser = new ServerInfoJsonParser();
    private final IssueTypeJsonParser issueTypeJsonParser = new IssueTypeJsonParser();
    private final GenericJsonArrayParser<IssueType> issueTypesJsonParser = GenericJsonArrayParser.create(this.issueTypeJsonParser);
    private final StatusJsonParser statusJsonParser = new StatusJsonParser();
    private final PriorityJsonParser priorityJsonParser = new PriorityJsonParser();
    private final GenericJsonArrayParser<Priority> prioritiesJsonParser = GenericJsonArrayParser.create(this.priorityJsonParser);
    private final ResolutionJsonParser resolutionJsonParser = new ResolutionJsonParser();
    private final GenericJsonArrayParser<Resolution> resolutionsJsonParser = GenericJsonArrayParser.create(this.resolutionJsonParser);
    private final IssueLinkTypesJsonParser issueLinkTypesJsonParser = new IssueLinkTypesJsonParser();
    private final URI baseUri;

    public AsynchronousMetadataRestClient(URI baseUri, HttpClient httpClient) {
        super(httpClient);
        this.baseUri = baseUri;
    }

    @Override
    public Promise<IssueType> getIssueType(URI uri) {
        return this.getAndParse(uri, this.issueTypeJsonParser);
    }

    @Override
    public Promise<Iterable<IssueType>> getIssueTypes() {
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path("issuetype").build(new Object[0]);
        return this.getAndParse(uri, this.issueTypesJsonParser);
    }

    @Override
    public Promise<Iterable<IssuelinksType>> getIssueLinkTypes() {
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path("issueLinkType").build(new Object[0]);
        return this.getAndParse(uri, this.issueLinkTypesJsonParser);
    }

    @Override
    public Promise<Status> getStatus(URI uri) {
        return this.getAndParse(uri, this.statusJsonParser);
    }

    @Override
    public Promise<Priority> getPriority(URI uri) {
        return this.getAndParse(uri, this.priorityJsonParser);
    }

    @Override
    public Promise<Iterable<Priority>> getPriorities() {
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path("priority").build(new Object[0]);
        return this.getAndParse(uri, this.prioritiesJsonParser);
    }

    @Override
    public Promise<Resolution> getResolution(URI uri) {
        return this.getAndParse(uri, this.resolutionJsonParser);
    }

    @Override
    public Promise<Iterable<Resolution>> getResolutions() {
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path("resolution").build(new Object[0]);
        return this.getAndParse(uri, this.resolutionsJsonParser);
    }

    @Override
    public Promise<ServerInfo> getServerInfo() {
        URI serverInfoUri = UriBuilder.fromUri((URI)this.baseUri).path(SERVER_INFO_RESOURCE).build(new Object[0]);
        return this.getAndParse(serverInfoUri, this.serverInfoJsonParser);
    }
}

