/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.jersey;

import com.atlassian.jira.rest.client.IssueRestClient;
import com.atlassian.jira.rest.client.NullProgressMonitor;
import com.atlassian.jira.rest.client.ProgressMonitor;
import com.atlassian.jira.rest.client.RestClientException;
import com.atlassian.jira.rest.client.SearchRestClient;
import com.atlassian.jira.rest.client.domain.FavouriteFilter;
import com.atlassian.jira.rest.client.domain.SearchResult;
import com.atlassian.jira.rest.client.internal.jersey.AbstractJerseyRestClient;
import com.atlassian.jira.rest.client.internal.json.FavouriteFilterJsonParser;
import com.atlassian.jira.rest.client.internal.json.GenericJsonArrayParser;
import com.atlassian.jira.rest.client.internal.json.SearchResultJsonParser;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.sun.jersey.client.apache.ApacheHttpClient;
import java.net.URI;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class JerseySearchRestClient
extends AbstractJerseyRestClient
implements SearchRestClient {
    private static final EnumSet<IssueRestClient.Expandos> DEFAULT_EXPANDS = EnumSet.of(IssueRestClient.Expandos.NAMES, IssueRestClient.Expandos.SCHEMA);
    private static final Function<IssueRestClient.Expandos, String> EXPANDO_TO_PARAM = new Function<IssueRestClient.Expandos, String>(){

        public String apply(IssueRestClient.Expandos from) {
            return from.name().toLowerCase();
        }
    };
    private static final String EXPAND_ATTRIBUTE = "expand";
    private static final String START_AT_ATTRIBUTE = "startAt";
    private static final String MAX_RESULTS_ATTRIBUTE = "maxResults";
    private static final int MAX_JQL_LENGTH_FOR_HTTP_GET = 500;
    private static final String JQL_ATTRIBUTE = "jql";
    private final SearchResultJsonParser keyOnlySearchResultJsonParser = new SearchResultJsonParser(false);
    private final SearchResultJsonParser fullSearchResultJsonParser = new SearchResultJsonParser(true);
    private final GenericJsonArrayParser<FavouriteFilter> favouriteFiltersJsonParser = GenericJsonArrayParser.create(new FavouriteFilterJsonParser());
    private static final String SEARCH_URI_PREFIX = "search";
    private final URI searchUri;

    public JerseySearchRestClient(URI baseUri, ApacheHttpClient client) {
        super(baseUri, client);
        this.searchUri = UriBuilder.fromUri((URI)baseUri).path(SEARCH_URI_PREFIX).build(new Object[0]);
    }

    @Override
    public SearchResult searchJql(@Nullable String jql, ProgressMonitor progressMonitor) {
        return this.searchJqlImpl(jql, null, null, progressMonitor, this.keyOnlySearchResultJsonParser);
    }

    @Override
    public SearchResult searchJql(@Nullable String jql, int maxResults, int startAt, ProgressMonitor progressMonitor) {
        return this.searchJqlImpl(jql, maxResults, startAt, progressMonitor, this.keyOnlySearchResultJsonParser);
    }

    @Override
    public SearchResult searchJqlWithFullIssues(@Nullable String jql, int maxResults, int startAt, ProgressMonitor progressMonitor) {
        return this.searchJqlImpl(jql, maxResults, startAt, progressMonitor, this.fullSearchResultJsonParser);
    }

    private SearchResult searchJqlImpl(@Nullable String jql, Integer maxResults, Integer startAt, ProgressMonitor progressMonitor, SearchResultJsonParser parser) {
        if (jql == null) {
            jql = "";
        }
        if (jql.length() > 500) {
            UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.searchUri);
            JSONObject postEntity = new JSONObject();
            try {
                postEntity.put(JQL_ATTRIBUTE, (Object)jql);
                if (maxResults != null && startAt != null) {
                    postEntity.put(START_AT_ATTRIBUTE, (Object)startAt);
                    postEntity.put(MAX_RESULTS_ATTRIBUTE, (Object)maxResults);
                }
                uriBuilder = uriBuilder.queryParam(EXPAND_ATTRIBUTE, new Object[]{Joiner.on((char)',').join(Iterables.transform(DEFAULT_EXPANDS, EXPANDO_TO_PARAM))});
            }
            catch (JSONException e) {
                throw new RestClientException(e);
            }
            return this.postAndParse(uriBuilder.build(new Object[0]), postEntity, parser, progressMonitor);
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.searchUri).queryParam(JQL_ATTRIBUTE, new Object[]{jql});
        if (maxResults != null && startAt != null) {
            uriBuilder = uriBuilder.queryParam(MAX_RESULTS_ATTRIBUTE, new Object[]{maxResults}).queryParam(START_AT_ATTRIBUTE, new Object[]{startAt});
        }
        URI uri = uriBuilder.queryParam(EXPAND_ATTRIBUTE, new Object[]{Joiner.on((char)',').join(Iterables.transform(DEFAULT_EXPANDS, EXPANDO_TO_PARAM))}).build(new Object[0]);
        return this.getAndParse(uri, parser, progressMonitor);
    }

    @Override
    public Iterable<FavouriteFilter> getFavouriteFilters(NullProgressMonitor progressMonitor) {
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path("filter/favourite").build(new Object[0]);
        return (Iterable)((Object)this.getAndParse(uri, this.favouriteFiltersJsonParser, (ProgressMonitor)progressMonitor));
    }
}

