/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.domain.input;

import com.atlassian.jira.rest.client.domain.BasicUser;
import com.atlassian.jira.rest.client.domain.Visibility;
import com.atlassian.jira.rest.client.domain.input.WorklogInputBuilder;
import com.google.common.base.Objects;
import java.net.URI;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class WorklogInput {
    @Nullable
    private final URI self;
    private final URI issueUri;
    @Nullable
    private final BasicUser author;
    @Nullable
    private final BasicUser updateAuthor;
    @Nullable
    private final String comment;
    private final DateTime startDate;
    @Nullable
    private final Integer minutesSpent;
    @Nullable
    private final String timeSpent;
    @Nullable
    private final Visibility visibility;
    @Nullable
    private final String adjustEstimateValue;
    private final AdjustEstimate adjustEstimate;

    public WorklogInput(@Nullable URI self, URI issueUri, @Nullable BasicUser author, @Nullable BasicUser updateAuthor, @Nullable String comment, DateTime startDate, @Nullable Integer minutesSpent, @Nullable String timeSpent, @Nullable Visibility visibility, AdjustEstimate adjustEstimate, @Nullable String adjustEstimateValue) {
        this.visibility = visibility;
        this.minutesSpent = minutesSpent;
        this.timeSpent = timeSpent;
        this.startDate = startDate;
        this.comment = comment;
        this.updateAuthor = updateAuthor;
        this.author = author;
        this.issueUri = issueUri;
        this.self = self;
        this.adjustEstimate = adjustEstimate;
        this.adjustEstimateValue = adjustEstimateValue;
    }

    public WorklogInput(@Nullable URI self, URI issueUri, @Nullable BasicUser author, @Nullable BasicUser updateAuthor, @Nullable String comment, DateTime startDate, int minutesSpent, @Nullable Visibility visibility) {
        this(self, issueUri, author, updateAuthor, comment, startDate, minutesSpent, null, visibility, AdjustEstimate.AUTO, null);
    }

    public WorklogInput(@Nullable URI self, URI issueUri, @Nullable BasicUser author, @Nullable BasicUser updateAuthor, @Nullable String comment, DateTime startDate, String timeSpent, @Nullable Visibility visibility) {
        this(self, issueUri, author, updateAuthor, comment, startDate, null, timeSpent, visibility, AdjustEstimate.AUTO, null);
    }

    public static WorklogInput create(URI issueUri, @Nullable String comment, DateTime startDate, int minutesSpent) {
        return new WorklogInputBuilder(issueUri).setComment(comment).setStartDate(startDate).setMinutesSpent(minutesSpent).build();
    }

    public static WorklogInput create(URI issueUri, @Nullable String comment, DateTime startDate, int minutesSpent, @Nullable Visibility visibility) {
        return new WorklogInputBuilder(issueUri).setComment(comment).setStartDate(startDate).setMinutesSpent(minutesSpent).setVisibility(visibility).build();
    }

    public static WorklogInput create(URI issueUri, @Nullable String comment, DateTime startDate, String timeSpent) {
        return new WorklogInputBuilder(issueUri).setComment(comment).setStartDate(startDate).setTimeSpent(timeSpent).build();
    }

    public static WorklogInput create(URI issueUri, @Nullable String comment, DateTime startDate, String timeSpent, @Nullable Visibility visibility) {
        return new WorklogInputBuilder(issueUri).setComment(comment).setStartDate(startDate).setTimeSpent(timeSpent).setVisibility(visibility).build();
    }

    @Nullable
    public URI getSelf() {
        return this.self;
    }

    public URI getIssueUri() {
        return this.issueUri;
    }

    @Nullable
    public BasicUser getAuthor() {
        return this.author;
    }

    @Nullable
    public BasicUser getUpdateAuthor() {
        return this.updateAuthor;
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    public DateTime getStartDate() {
        return this.startDate;
    }

    @Nullable
    public Integer getMinutesSpent() {
        return this.minutesSpent;
    }

    @Nullable
    public String getTimeSpent() {
        return this.timeSpent;
    }

    @Nullable
    public Visibility getVisibility() {
        return this.visibility;
    }

    public AdjustEstimate getAdjustEstimate() {
        return this.adjustEstimate;
    }

    @Nullable
    public String getAdjustEstimateValue() {
        return this.adjustEstimateValue;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("self", (Object)this.self).add("issueUri", (Object)this.issueUri).add("author", (Object)this.author).add("updateAuthor", (Object)this.updateAuthor).add("comment", (Object)this.comment).add("startDate", (Object)this.startDate).add("minutesSpent", (Object)this.minutesSpent).add("timeSpent", (Object)this.timeSpent).add("visibility", (Object)this.visibility).add("adjustEstimate", (Object)this.adjustEstimate).add("adjustEstimateValue", (Object)this.adjustEstimateValue).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof WorklogInput) {
            WorklogInput that = (WorklogInput)obj;
            return Objects.equal((Object)this.self, (Object)that.self) && Objects.equal((Object)this.issueUri, (Object)that.issueUri) && Objects.equal((Object)this.author, (Object)that.author) && Objects.equal((Object)this.updateAuthor, (Object)that.updateAuthor) && Objects.equal((Object)this.comment, (Object)that.comment) && Objects.equal((Object)this.startDate, (Object)that.startDate) && Objects.equal((Object)this.minutesSpent, (Object)that.minutesSpent) && Objects.equal((Object)this.timeSpent, (Object)that.timeSpent) && Objects.equal((Object)this.visibility, (Object)that.visibility) && Objects.equal((Object)((Object)this.adjustEstimate), (Object)((Object)that.adjustEstimate)) && Objects.equal((Object)this.adjustEstimateValue, (Object)that.adjustEstimateValue);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.self, this.issueUri, this.author, this.updateAuthor, this.comment, this.startDate, this.minutesSpent, this.timeSpent, this.visibility, this.adjustEstimate, this.adjustEstimateValue});
    }

    public static enum AdjustEstimate {
        NEW,
        LEAVE,
        MANUAL,
        AUTO;

        public final String restValue = this.name().toLowerCase();
    }
}

