/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.domain.input;

import com.atlassian.jira.rest.client.IdentifiableEntity;
import com.atlassian.jira.rest.client.NamedEntity;
import com.atlassian.jira.rest.client.domain.BasicProject;
import com.atlassian.jira.rest.client.domain.CustomFieldOption;
import com.atlassian.jira.rest.client.domain.TimeTracking;
import com.atlassian.jira.rest.client.domain.input.ComplexIssueInputFieldValue;
import com.atlassian.jira.rest.client.domain.input.ValueTransformer;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class BaseValueTransformer
implements ValueTransformer {
    @Override
    public Object apply(Object rawValue) {
        if (rawValue == null) {
            return null;
        }
        if (rawValue instanceof String || rawValue instanceof Number || rawValue instanceof ComplexIssueInputFieldValue) {
            return rawValue;
        }
        if (rawValue instanceof BasicProject) {
            return new ComplexIssueInputFieldValue((Map<String, Object>)ImmutableMap.of((Object)"key", (Object)((BasicProject)rawValue).getKey()));
        }
        if (rawValue instanceof CustomFieldOption) {
            return this.transformCustomFieldOption((CustomFieldOption)rawValue);
        }
        if (rawValue instanceof TimeTracking) {
            return this.transformTimeTracking((TimeTracking)rawValue);
        }
        if (rawValue instanceof IdentifiableEntity) {
            IdentifiableEntity identifiableEntity = (IdentifiableEntity)rawValue;
            return new ComplexIssueInputFieldValue((Map<String, Object>)ImmutableMap.of((Object)"id", (Object)identifiableEntity.getId().toString()));
        }
        if (rawValue instanceof NamedEntity) {
            NamedEntity namedEntity = (NamedEntity)rawValue;
            return new ComplexIssueInputFieldValue((Map<String, Object>)ImmutableMap.of((Object)"name", (Object)namedEntity.getName()));
        }
        return CANNOT_HANDLE;
    }

    private ComplexIssueInputFieldValue transformCustomFieldOption(CustomFieldOption cfo) {
        if (cfo.getChild() != null) {
            return new ComplexIssueInputFieldValue((Map<String, Object>)ImmutableMap.of((Object)"id", (Object)cfo.getId().toString(), (Object)"value", (Object)cfo.getValue(), (Object)"child", (Object)this.apply(cfo.getChild())));
        }
        return new ComplexIssueInputFieldValue((Map<String, Object>)ImmutableMap.of((Object)"id", (Object)cfo.getId().toString(), (Object)"value", (Object)cfo.getValue()));
    }

    private ComplexIssueInputFieldValue transformTimeTracking(TimeTracking timeTracking) {
        Integer remainingEstimateMinutes;
        HashMap fields = Maps.newHashMap();
        Integer originalEstimateMinutes = timeTracking.getOriginalEstimateMinutes();
        if (originalEstimateMinutes != null) {
            fields.put("originalEstimate", originalEstimateMinutes + "m");
        }
        if ((remainingEstimateMinutes = timeTracking.getRemainingEstimateMinutes()) != null) {
            fields.put("remainingEstimate", remainingEstimateMinutes + "m");
        }
        return new ComplexIssueInputFieldValue(fields);
    }
}

