/*
 * Copyright (C) 2010 Atlassian
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.atlassian.jira.rest.client.domain;

import com.atlassian.jira.rest.client.AddressableEntity;
import com.atlassian.jira.rest.client.IdentifiableEntity;
import com.atlassian.jira.rest.client.NamedEntity;
import com.google.common.base.Objects;

import javax.annotation.Nullable;
import java.net.URI;

/**
 * Basic information about issue type.
 *
 * @since v0.1
 */
public class BasicIssueType implements AddressableEntity, NamedEntity, IdentifiableEntity<Long> {
	private final URI self;

	@Nullable
	private final Long id;

	private final String name;

	private final boolean isSubtask;

	public BasicIssueType(URI self, @Nullable Long id, String name, boolean isSubtask) {
		this.self = self;
		this.id = id;
		this.name = name;
		this.isSubtask = isSubtask;
	}

	@Nullable
	public Long getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	public boolean isSubtask() {
		return isSubtask;
	}

	@Override
	public URI getSelf() {
		return self;
	}

	/**
	 * Returns ToStringHelper with all fields inserted. Override this method to insert additional fields.
	 * @return ToStringHelper
	 */
	protected Objects.ToStringHelper getToStringHelper() {
		return Objects.toStringHelper(this).
				add("self", self).
				add("id", id).
				add("name", name).
				add("isSubtask", isSubtask);
	}

	@Override
	public String toString() {
		return getToStringHelper().toString();
	}


	@Override
	public boolean equals(Object obj) {
		if (obj instanceof BasicIssueType) {
			BasicIssueType that = (BasicIssueType) obj;
			return Objects.equal(this.self, that.self)
					&& Objects.equal(this.id, that.id)
					&& Objects.equal(this.name, that.name)
					&& Objects.equal(this.isSubtask, that.isSubtask);
		}
		return false;
	}

	@Override
	public int hashCode() {
		return Objects.hashCode(self, id, name, isSubtask);
	}
}
