/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json;

import com.atlassian.jira.rest.client.domain.Attachment;
import com.atlassian.jira.rest.client.domain.BasicComponent;
import com.atlassian.jira.rest.client.domain.BasicIssueType;
import com.atlassian.jira.rest.client.domain.BasicPriority;
import com.atlassian.jira.rest.client.domain.BasicProject;
import com.atlassian.jira.rest.client.domain.BasicResolution;
import com.atlassian.jira.rest.client.domain.BasicStatus;
import com.atlassian.jira.rest.client.domain.BasicUser;
import com.atlassian.jira.rest.client.domain.BasicVotes;
import com.atlassian.jira.rest.client.domain.BasicWatchers;
import com.atlassian.jira.rest.client.domain.Comment;
import com.atlassian.jira.rest.client.domain.Field;
import com.atlassian.jira.rest.client.domain.Issue;
import com.atlassian.jira.rest.client.domain.IssueLink;
import com.atlassian.jira.rest.client.domain.TimeTracking;
import com.atlassian.jira.rest.client.domain.Version;
import com.atlassian.jira.rest.client.domain.Worklog;
import com.atlassian.jira.rest.client.internal.json.AttachmentJsonParser;
import com.atlassian.jira.rest.client.internal.json.BasicComponentJsonParser;
import com.atlassian.jira.rest.client.internal.json.BasicIssueTypeJsonParser;
import com.atlassian.jira.rest.client.internal.json.BasicPriorityJsonParser;
import com.atlassian.jira.rest.client.internal.json.BasicProjectJsonParser;
import com.atlassian.jira.rest.client.internal.json.BasicResolutionJsonParser;
import com.atlassian.jira.rest.client.internal.json.BasicStatusJsonParser;
import com.atlassian.jira.rest.client.internal.json.BasicUserJsonParser;
import com.atlassian.jira.rest.client.internal.json.BasicVotesJsonParser;
import com.atlassian.jira.rest.client.internal.json.CommentJsonParser;
import com.atlassian.jira.rest.client.internal.json.IssueLinkJsonParser;
import com.atlassian.jira.rest.client.internal.json.IssueLinkJsonParserV5;
import com.atlassian.jira.rest.client.internal.json.JsonFieldParser;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.atlassian.jira.rest.client.internal.json.JsonParser;
import com.atlassian.jira.rest.client.internal.json.JsonWeakParser;
import com.atlassian.jira.rest.client.internal.json.JsonWeakParserForJsonObject;
import com.atlassian.jira.rest.client.internal.json.TimeTrackingJsonParser;
import com.atlassian.jira.rest.client.internal.json.TimeTrackingJsonParserV5;
import com.atlassian.jira.rest.client.internal.json.TransitionJsonParser;
import com.atlassian.jira.rest.client.internal.json.VersionJsonParser;
import com.atlassian.jira.rest.client.internal.json.WatchersJsonParserBuilder;
import com.atlassian.jira.rest.client.internal.json.WorklogJsonParser;
import com.atlassian.jira.rest.client.internal.json.WorklogJsonParserV5;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.joda.time.DateTime;

public class IssueJsonParser
implements JsonParser<Issue> {
    private static final String UPDATED_ATTR = "updated";
    private static final String CREATED_ATTR = "created";
    private static final String AFFECTS_VERSIONS_ATTR = "versions";
    private static final String FIX_VERSIONS_ATTR = "fixVersions";
    private static final String COMPONENTS_ATTR = "components";
    private static final String LINKS_ATTR = "links";
    private static final String LINKS_ATTR_5_0 = "issuelinks";
    private static final String ISSUE_TYPE_ATTR = "issuetype";
    private static final String VOTES_ATTR = "votes";
    private static final String WORKLOG_ATTR = "worklog";
    private static final String WORKLOGS_ATTR = "worklogs";
    private static final String WATCHER_ATTR = "watcher";
    private static final String WATCHER_ATTR_5_0 = "watches";
    private static final String PROJECT_ATTR = "project";
    private static final String STATUS_ATTR = "status";
    private static final String COMMENT_ATTR = "comment";
    private static final String PRIORITY_ATTR = "priority";
    private static final String ATTACHMENT_ATTR = "attachment";
    private static final String RESOLUTION_ATTR = "resolution";
    private static final String ASSIGNEE_ATTR = "assignee";
    private static final String REPORTER_ATTR = "reporter";
    private static final String SUMMARY_ATTR = "summary";
    private static final String DESCRIPTION_ATTR = "description";
    private static final String TIMETRACKING_ATTR = "timetracking";
    private static final String TRANSITIONS_ATTR = "transitions";
    private static Set<String> SPECIAL_FIELDS = new HashSet<String>(Arrays.asList("summary", "updated", "created", "versions", "fixVersions", "components", "links", "issuelinks", "issuetype", "votes", "worklog", "watcher", "project", "status", "comment", "attachment", "summary", "description", "priority", "resolution", "assignee", "reporter", "timetracking"));
    public static final String SCHEMA_SECTION = "schema";
    public static final String NAMES_SECTION = "names";
    public static final String TRANSITIONS_SECTION = "transitions";
    private final IssueLinkJsonParser issueLinkJsonParser = new IssueLinkJsonParser();
    private final IssueLinkJsonParserV5 issueLinkJsonParserV5 = new IssueLinkJsonParserV5();
    private final BasicVotesJsonParser votesJsonParser = new BasicVotesJsonParser();
    private final BasicStatusJsonParser statusJsonParser = new BasicStatusJsonParser();
    private final WorklogJsonParser worklogJsonParser = new WorklogJsonParser();
    private final JsonParser<BasicWatchers> watchersJsonParser = WatchersJsonParserBuilder.createBasicWatchersParser();
    private final VersionJsonParser versionJsonParser = new VersionJsonParser();
    private final BasicComponentJsonParser basicComponentJsonParser = new BasicComponentJsonParser();
    private final AttachmentJsonParser attachmentJsonParser = new AttachmentJsonParser();
    private final JsonFieldParser fieldParser = new JsonFieldParser();
    private final CommentJsonParser commentJsonParser = new CommentJsonParser();
    private final BasicIssueTypeJsonParser issueTypeJsonParser = new BasicIssueTypeJsonParser();
    private final BasicProjectJsonParser projectJsonParser = new BasicProjectJsonParser();
    private final BasicPriorityJsonParser priorityJsonParser = new BasicPriorityJsonParser();
    private final BasicResolutionJsonParser resolutionJsonParser = new BasicResolutionJsonParser();
    private final BasicUserJsonParser userJsonParser = new BasicUserJsonParser();
    private final TransitionJsonParser transitionJsonParser = new TransitionJsonParser();
    private static final String FIELDS = "fields";
    private static final String VALUE_ATTR = "value";

    static Iterable<String> parseExpandos(JSONObject json) throws JSONException {
        String expando = json.getString("expand");
        return Splitter.on((char)',').split((CharSequence)expando);
    }

    private <T> Collection<T> parseArray(JSONObject jsonObject, JsonWeakParser<T> jsonParser, String arrayAttribute) throws JSONException {
        JSONArray valueObject = jsonObject.optJSONArray(arrayAttribute);
        if (valueObject == null) {
            return new ArrayList();
        }
        ArrayList<T> res = new ArrayList<T>(valueObject.length());
        for (int i = 0; i < valueObject.length(); ++i) {
            res.add(jsonParser.parse(valueObject.get(i)));
        }
        return res;
    }

    @Nullable
    private <T> Collection<T> parseOptionalArray(boolean shouldUseNestedValueJson, JSONObject json, JsonWeakParser<T> jsonParser, String ... path) throws JSONException {
        if (shouldUseNestedValueJson) {
            JSONObject js = JsonParseUtil.getNestedOptionalObject(json, path);
            if (js == null) {
                return null;
            }
            return this.parseArray(js, jsonParser, VALUE_ATTR);
        }
        JSONArray jsonArray = JsonParseUtil.getNestedOptionalArray(json, path);
        if (jsonArray == null) {
            return null;
        }
        ArrayList<T> res = new ArrayList<T>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            res.add(jsonParser.parse(jsonArray.get(i)));
        }
        return res;
    }

    private String getFieldStringValue(JSONObject json, String attributeName) throws JSONException {
        JSONObject fieldsJson = json.getJSONObject(FIELDS);
        Object summaryObject = fieldsJson.get(attributeName);
        if (summaryObject instanceof JSONObject) {
            return ((JSONObject)summaryObject).getString(VALUE_ATTR);
        }
        if (summaryObject instanceof String) {
            return (String)summaryObject;
        }
        throw new JSONException("Cannot parse [" + attributeName + "] from available fields");
    }

    private JSONObject getFieldUnisex(JSONObject json, String attributeName) throws JSONException {
        JSONObject fieldsJson = json.getJSONObject(FIELDS);
        JSONObject fieldJson = fieldsJson.getJSONObject(attributeName);
        if (fieldJson.has(VALUE_ATTR)) {
            return fieldJson.getJSONObject(VALUE_ATTR);
        }
        return fieldJson;
    }

    @Nullable
    private String getOptionalFieldStringUnisex(boolean shouldUseNestedValueJson, JSONObject json, String attributeName) throws JSONException {
        JSONObject fieldsJson = json.getJSONObject(FIELDS);
        if (shouldUseNestedValueJson) {
            JSONObject fieldJson = fieldsJson.optJSONObject(attributeName);
            if (fieldJson != null) {
                return JsonParseUtil.getOptionalString(fieldJson, VALUE_ATTR);
            }
            return null;
        }
        return JsonParseUtil.getOptionalString(fieldsJson, attributeName);
    }

    private String getFieldStringUnisex(JSONObject json, String attributeName) throws JSONException {
        JSONObject fieldsJson = json.getJSONObject(FIELDS);
        Object fieldJson = fieldsJson.get(attributeName);
        if (fieldJson instanceof JSONObject) {
            return ((JSONObject)fieldJson).getString(VALUE_ATTR);
        }
        return fieldJson.toString();
    }

    @Override
    public Issue parse(JSONObject s) throws JSONException {
        ArrayList comments;
        boolean shouldUseNestedValueAttribute;
        Iterable<String> expandos = IssueJsonParser.parseExpandos(s);
        boolean isJira5x0OrNewer = Iterables.contains(expandos, (Object)SCHEMA_SECTION);
        boolean bl = shouldUseNestedValueAttribute = !isJira5x0OrNewer;
        if (isJira5x0OrNewer) {
            JSONObject commentsJson = s.getJSONObject(FIELDS).getJSONObject(COMMENT_ATTR);
            comments = this.parseArray(commentsJson, new JsonWeakParserForJsonObject<Comment>(this.commentJsonParser), "comments");
        } else {
            ArrayList commentsTmp = this.parseOptionalArray(shouldUseNestedValueAttribute, s, new JsonWeakParserForJsonObject<Comment>(this.commentJsonParser), FIELDS, COMMENT_ATTR);
            comments = commentsTmp != null ? commentsTmp : Lists.newArrayList();
        }
        String summary = this.getFieldStringValue(s, SUMMARY_ATTR);
        String description = this.getOptionalFieldStringUnisex(shouldUseNestedValueAttribute, s, DESCRIPTION_ATTR);
        Collection<Attachment> attachments = this.parseOptionalArray(shouldUseNestedValueAttribute, s, new JsonWeakParserForJsonObject<Attachment>(this.attachmentJsonParser), FIELDS, ATTACHMENT_ATTR);
        Collection<Field> fields = isJira5x0OrNewer ? this.parseFieldsJira5x0(s) : this.parseFields(s.getJSONObject(FIELDS));
        BasicIssueType issueType = this.issueTypeJsonParser.parse(this.getFieldUnisex(s, ISSUE_TYPE_ATTR));
        DateTime creationDate = JsonParseUtil.parseDateTime(this.getFieldStringUnisex(s, CREATED_ATTR));
        DateTime updateDate = JsonParseUtil.parseDateTime(this.getFieldStringUnisex(s, UPDATED_ATTR));
        BasicPriority priority = this.getOptionalField(shouldUseNestedValueAttribute, s, PRIORITY_ATTR, this.priorityJsonParser);
        BasicResolution resolution = this.getOptionalField(shouldUseNestedValueAttribute, s, RESOLUTION_ATTR, this.resolutionJsonParser);
        BasicUser assignee = this.getOptionalField(shouldUseNestedValueAttribute, s, ASSIGNEE_ATTR, this.userJsonParser);
        BasicUser reporter = this.getOptionalField(shouldUseNestedValueAttribute, s, REPORTER_ATTR, this.userJsonParser);
        String transitionsUri = this.getOptionalFieldStringUnisex(shouldUseNestedValueAttribute, s, "transitions");
        BasicProject project = this.projectJsonParser.parse(this.getFieldUnisex(s, PROJECT_ATTR));
        Collection<IssueLink> issueLinks = isJira5x0OrNewer ? this.parseOptionalArray(shouldUseNestedValueAttribute, s, new JsonWeakParserForJsonObject<IssueLink>(this.issueLinkJsonParserV5), FIELDS, LINKS_ATTR_5_0) : this.parseOptionalArray(shouldUseNestedValueAttribute, s, new JsonWeakParserForJsonObject<IssueLink>(this.issueLinkJsonParser), FIELDS, LINKS_ATTR);
        BasicVotes votes = this.getOptionalField(shouldUseNestedValueAttribute, s, VOTES_ATTR, this.votesJsonParser);
        BasicStatus status = this.statusJsonParser.parse(this.getFieldUnisex(s, STATUS_ATTR));
        Collection<Version> fixVersions = this.parseOptionalArray(shouldUseNestedValueAttribute, s, new JsonWeakParserForJsonObject<Version>(this.versionJsonParser), FIELDS, FIX_VERSIONS_ATTR);
        Collection<Version> affectedVersions = this.parseOptionalArray(shouldUseNestedValueAttribute, s, new JsonWeakParserForJsonObject<Version>(this.versionJsonParser), FIELDS, AFFECTS_VERSIONS_ATTR);
        Collection<BasicComponent> components = this.parseOptionalArray(shouldUseNestedValueAttribute, s, new JsonWeakParserForJsonObject<BasicComponent>(this.basicComponentJsonParser), FIELDS, COMPONENTS_ATTR);
        Collection<Object> worklogs = isJira5x0OrNewer ? (JsonParseUtil.getNestedOptionalObject(s, FIELDS, WORKLOG_ATTR) != null ? this.parseOptionalArray(shouldUseNestedValueAttribute, s, new JsonWeakParserForJsonObject<Worklog>(new WorklogJsonParserV5(JsonParseUtil.getSelfUri(s))), FIELDS, WORKLOG_ATTR, WORKLOGS_ATTR) : Collections.emptyList()) : this.parseOptionalArray(shouldUseNestedValueAttribute, s, new JsonWeakParserForJsonObject<Worklog>(this.worklogJsonParser), FIELDS, WORKLOG_ATTR);
        BasicWatchers watchers = this.getOptionalField(shouldUseNestedValueAttribute, s, isJira5x0OrNewer ? WATCHER_ATTR_5_0 : WATCHER_ATTR, this.watchersJsonParser);
        TimeTracking timeTracking = this.getOptionalField(shouldUseNestedValueAttribute, s, TIMETRACKING_ATTR, isJira5x0OrNewer ? new TimeTrackingJsonParserV5() : new TimeTrackingJsonParser());
        return new Issue(summary, JsonParseUtil.getSelfUri(s), s.getString("key"), project, issueType, status, description, priority, resolution, attachments, reporter, assignee, creationDate, updateDate, affectedVersions, fixVersions, components, timeTracking, fields, comments, transitionsUri != null ? JsonParseUtil.parseURI(transitionsUri) : null, issueLinks, votes, worklogs, watchers, expandos);
    }

    @Nullable
    private <T> T getOptionalField(boolean shouldUseNestedValue, JSONObject s, String fieldId, JsonParser<T> jsonParser) throws JSONException {
        JSONObject fieldJson = JsonParseUtil.getNestedOptionalObject(s, FIELDS, fieldId);
        if (fieldJson != null) {
            if (shouldUseNestedValue) {
                JSONObject valueJsonObject = fieldJson.optJSONObject(VALUE_ATTR);
                if (valueJsonObject != null) {
                    return jsonParser.parse(valueJsonObject);
                }
            } else {
                return jsonParser.parse(fieldJson);
            }
        }
        return null;
    }

    private Collection<Field> parseFieldsJira5x0(JSONObject issueJson) throws JSONException {
        JSONObject names = issueJson.optJSONObject(NAMES_SECTION);
        Map<String, String> namesMap = this.parseNames(names);
        JSONObject types = issueJson.optJSONObject(SCHEMA_SECTION);
        Map<String, String> typesMap = this.parseSchema(types);
        JSONObject json = issueJson.getJSONObject(FIELDS);
        ArrayList<Field> res = new ArrayList<Field>(json.length());
        Iterator iterator = json.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            try {
                Object value;
                if (SPECIAL_FIELDS.contains(key)) continue;
                res.add(new Field(key, namesMap.get(key), typesMap.get("key"), (value = json.opt(key)) != JSONObject.NULL ? value : null));
            }
            catch (Exception e) {
                throw new JSONException("Error while parsing [" + key + "] field: " + e.getMessage()){

                    public Throwable getCause() {
                        return e;
                    }
                };
            }
        }
        return res;
    }

    private Map<String, String> parseSchema(JSONObject json) throws JSONException {
        HashMap res = Maps.newHashMap();
        Iterator it = json.keys();
        while (it.hasNext()) {
            String fieldId = (String)it.next();
            JSONObject fieldDefinition = json.getJSONObject(fieldId);
            res.put(fieldId, fieldDefinition.getString("type"));
        }
        return res;
    }

    private Map<String, String> parseNames(JSONObject json) throws JSONException {
        HashMap res = Maps.newHashMap();
        Iterator it = json.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            res.put(key, json.getString(key));
        }
        return res;
    }

    private Collection<Field> parseFields(JSONObject json) throws JSONException {
        ArrayList<Field> res = new ArrayList<Field>(json.length());
        Iterator iterator = json.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (SPECIAL_FIELDS.contains(key)) continue;
            res.add(this.fieldParser.parse(json.getJSONObject(key), key));
        }
        return res;
    }
}

