/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json;

import com.atlassian.jira.rest.client.domain.Visibility;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.atlassian.jira.rest.client.internal.json.JsonParser;
import javax.annotation.Nullable;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class VisibilityJsonParser
implements JsonParser<Visibility> {
    private static final String ROLE_TYPE = "ROLE";
    private static final String GROUP_TYPE = "GROUP";

    @Override
    public Visibility parse(JSONObject json) throws JSONException {
        Visibility.Type visibilityType;
        String type = json.getString("type");
        if (ROLE_TYPE.equalsIgnoreCase(type)) {
            visibilityType = Visibility.Type.ROLE;
        } else if (GROUP_TYPE.equalsIgnoreCase(type)) {
            visibilityType = Visibility.Type.GROUP;
        } else {
            throw new JSONException("[" + type + "] does not represent a valid visibility type. Expected [" + ROLE_TYPE + "] or [" + GROUP_TYPE + "].");
        }
        String value = json.getString("value");
        return new Visibility(visibilityType, value);
    }

    @Nullable
    public Visibility parseVisibility(JSONObject parentObject) throws JSONException {
        if (parentObject.has("visibility")) {
            return this.parse(parentObject.getJSONObject("visibility"));
        }
        String roleLevel = parentObject.optString("roleLevel", null);
        if (roleLevel == null) {
            roleLevel = JsonParseUtil.getOptionalString(parentObject, "role");
        }
        if (roleLevel != null) {
            return Visibility.role(roleLevel);
        }
        String groupLevel = parentObject.optString("groupLevel", null);
        if (groupLevel != null) {
            return Visibility.group(groupLevel);
        }
        return null;
    }
}

