/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.test.matchers;

import com.atlassian.jira.rest.client.api.AddressableEntity;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;

public class AddressableEntityMatchers {
    public static Matcher<? super AddressableEntity> withSelf(URI uri) {
        return new FeatureMatcher<AddressableEntity, URI>(Matchers.is((Object)uri), "entity with self that", "self"){

            protected URI featureValueOf(AddressableEntity AddressableEntity2) {
                return AddressableEntity2.getSelf();
            }
        };
    }

    public static Matcher<Iterable<? extends AddressableEntity>> entitiesWithSelf(URI ... uris) {
        ArrayList matchers = Lists.newArrayListWithCapacity((int)uris.length);
        for (URI uri : uris) {
            matchers.add(AddressableEntityMatchers.withSelf(uri));
        }
        return IsIterableContainingInAnyOrder.containsInAnyOrder((Collection)matchers);
    }
}

