/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.test.matchers;

import com.atlassian.jira.rest.client.api.domain.SearchResult;
import com.google.common.collect.Iterables;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class SearchResultMatchers {
    public static Matcher<? super SearchResult> withStartIndex(int startIndex) {
        return new FeatureMatcher<SearchResult, Integer>(Matchers.is((Object)startIndex), "search result with start index that", "startIndex"){

            protected Integer featureValueOf(SearchResult searchResult) {
                return searchResult.getStartIndex();
            }
        };
    }

    public static Matcher<? super SearchResult> withMaxResults(int maxResults) {
        return new FeatureMatcher<SearchResult, Integer>(Matchers.is((Object)maxResults), "search result with max results that", "maxResults"){

            protected Integer featureValueOf(SearchResult searchResult) {
                return searchResult.getMaxResults();
            }
        };
    }

    public static Matcher<? super SearchResult> withTotal(int total) {
        return new FeatureMatcher<SearchResult, Integer>(Matchers.is((Object)total), "search result with total that", "total"){

            protected Integer featureValueOf(SearchResult searchResult) {
                return searchResult.getTotal();
            }
        };
    }

    public static Matcher<? super SearchResult> withIssueCount(int issueCount) {
        return new FeatureMatcher<SearchResult, Integer>(Matchers.is((Object)issueCount), "search result with issue count that", "issue count"){

            protected Integer featureValueOf(SearchResult searchResult) {
                Iterable issues = searchResult.getIssues();
                return issues == null ? 0 : Iterables.size((Iterable)issues);
            }
        };
    }

    public static Matcher<? super SearchResult> searchResultWithParamsAndIssueCount(int startIndex, int maxResults, int total, int issueCount) {
        return Matchers.allOf(SearchResultMatchers.withStartIndex(startIndex), SearchResultMatchers.withMaxResults(maxResults), SearchResultMatchers.withTotal(total), SearchResultMatchers.withIssueCount(issueCount));
    }
}

