/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.api.domain;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;

public enum IssueFieldId {
    AFFECTS_VERSIONS_FIELD("versions"),
    ASSIGNEE_FIELD("assignee"),
    ATTACHMENT_FIELD("attachment"),
    COMMENT_FIELD("comment"),
    COMPONENTS_FIELD("components"),
    CREATED_FIELD("created"),
    DESCRIPTION_FIELD("description"),
    DUE_DATE_FIELD("duedate"),
    FIX_VERSIONS_FIELD("fixVersions"),
    ISSUE_TYPE_FIELD("issuetype"),
    LABELS_FIELD("labels"),
    LINKS_FIELD("issuelinks"),
    LINKS_PRE_5_0_FIELD("links"),
    PRIORITY_FIELD("priority"),
    PROJECT_FIELD("project"),
    REPORTER_FIELD("reporter"),
    RESOLUTION_FIELD("resolution"),
    STATUS_FIELD("status"),
    SUBTASKS_FIELD("subtasks"),
    PARENTTASKS_FIELD("parent"),
    SUMMARY_FIELD("summary"),
    TIMETRACKING_FIELD("timetracking"),
    TRANSITIONS_FIELD("transitions"),
    UPDATED_FIELD("updated"),
    VOTES_FIELD("votes"),
    WATCHER_FIELD("watches"),
    WATCHER_PRE_5_0_FIELD("watcher"),
    WORKLOG_FIELD("worklog"),
    WORKLOGS_FIELD("worklogs");

    public final String id;
    public static final Function<IssueFieldId, String> TRANSFORM_TO_ID_FUNCTION;

    private IssueFieldId(String id) {
        this.id = id;
    }

    public static Iterable<String> ids() {
        return Iterables.transform((Iterable)Lists.newArrayList((Object[])IssueFieldId.values()), TRANSFORM_TO_ID_FUNCTION);
    }

    static {
        TRANSFORM_TO_ID_FUNCTION = new Function<IssueFieldId, String>(){

            public String apply(IssueFieldId from) {
                return from.id;
            }
        };
    }
}

