/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.api.domain.util;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;

public class ErrorCollection {
    private final Integer status;
    private final Collection<String> errorMessages;
    private final Map<String, String> errors;

    public ErrorCollection(@Nullable Integer status, Collection<String> errorMessages, Map<String, String> errors) {
        this.status = status;
        this.errors = ImmutableMap.copyOf(errors);
        this.errorMessages = ImmutableList.copyOf(errorMessages);
    }

    public ErrorCollection(String errorMessage) {
        this(null, (Collection<String>)ImmutableList.of((Object)errorMessage), Collections.emptyMap());
    }

    @Nullable
    public Integer getStatus() {
        return this.status;
    }

    public Collection<String> getErrorMessages() {
        return this.errorMessages;
    }

    public Map<String, String> getErrors() {
        return this.errors;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("errors", this.errors).add("errorMessages", this.errorMessages).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ErrorCollection) {
            ErrorCollection that = (ErrorCollection)obj;
            return Objects.equal((Object)this.status, (Object)that.status) && Objects.equal(this.errors, that.errors) && Objects.equal(this.errorMessages, that.errorMessages);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.status, this.errors, this.errorMessages});
    }

    public static class Builder {
        private int status;
        private final ImmutableMap.Builder<String, String> errors = ImmutableMap.builder();
        private final ImmutableList.Builder<String> errorMessages = ImmutableList.builder();

        public Builder status(int status) {
            this.status = status;
            return this;
        }

        public Builder error(String key, String message) {
            this.errors.put((Object)key, (Object)message);
            return this;
        }

        public Builder errorMessage(String message) {
            this.errorMessages.add((Object)message);
            return this;
        }

        public ErrorCollection build() {
            return new ErrorCollection(this.status, (Collection<String>)this.errorMessages.build(), (Map<String, String>)this.errors.build());
        }
    }
}

