/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.api.domain;

import com.atlassian.jira.rest.client.api.domain.Operation;
import com.atlassian.jira.rest.client.api.domain.OperationHeader;
import com.atlassian.jira.rest.client.api.domain.OperationLink;
import com.atlassian.jira.rest.client.api.domain.OperationVisitor;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import java.util.Collections;
import javax.annotation.Nullable;

public class OperationGroup
implements Operation {
    @Nullable
    private final String id;
    @Nullable
    private final OperationHeader header;
    private final Iterable<OperationLink> links;
    private final Iterable<OperationGroup> groups;
    @Nullable
    private final Integer weight;

    public OperationGroup(@Nullable String id, Iterable<OperationLink> links, Iterable<OperationGroup> groups, @Nullable OperationHeader header, @Nullable Integer weight) {
        this.id = id;
        this.header = header;
        this.links = links;
        this.groups = groups;
        this.weight = weight;
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    public <T> Optional<T> accept(OperationVisitor<T> visitor) {
        Optional<T> result = visitor.visit(this);
        if (result.isPresent()) {
            return result;
        }
        Iterable operations = Iterables.concat(this.header != null ? Collections.singleton(this.header) : Collections.emptyList(), this.links, this.groups);
        return OperationGroup.accept(operations, visitor);
    }

    static <T> Optional<T> accept(Iterable<? extends Operation> operations, OperationVisitor<T> visitor) {
        for (Operation operation : operations) {
            Optional<T> result = operation.accept(visitor);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.absent();
    }

    @Nullable
    public OperationHeader getHeader() {
        return this.header;
    }

    public Iterable<OperationLink> getLinks() {
        return this.links;
    }

    public Iterable<OperationGroup> getGroups() {
        return this.groups;
    }

    @Nullable
    public Integer getWeight() {
        return this.weight;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.header, this.links, this.groups, this.weight});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OperationGroup other = (OperationGroup)obj;
        return Objects.equal((Object)this.id, (Object)other.id) && Objects.equal((Object)this.header, (Object)other.header) && Iterables.elementsEqual(this.links, other.links) && Iterables.elementsEqual(this.groups, other.groups) && Objects.equal((Object)this.weight, (Object)other.weight);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("header", (Object)this.header).add("links", (Object)Iterables.toString(this.links)).add("groups", (Object)Iterables.toString(this.groups)).add("weight", (Object)this.weight).toString();
    }
}

