/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.api.issue;

import com.atlassian.jira.rest.api.issue.IssueFields;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;

public class FieldsSerializer
extends JsonSerializer<IssueFields> {
    public void serialize(IssueFields issueFields, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        if (issueFields != null) {
            jgen.writeStartObject();
            this.serializeSystemFields(issueFields, jgen, provider);
            this.serializeCustomFields(issueFields, jgen, provider);
            jgen.writeEndObject();
        }
    }

    protected void serializeSystemFields(IssueFields issueFields, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        for (Field field : issueFields.getClass().getFields()) {
            JsonProperty jsonAnnotation = field.getAnnotation(JsonProperty.class);
            if (!FieldsSerializer.isPublic(field) && jsonAnnotation == null) continue;
            try {
                Object fieldValue = field.get(issueFields);
                if (fieldValue == null) continue;
                String overrideName = jsonAnnotation != null ? jsonAnnotation.value() : null;
                String jsonName = !StringUtils.isEmpty((CharSequence)overrideName) ? overrideName : field.getName();
                provider.defaultSerializeField(jsonName, fieldValue, jgen);
            }
            catch (IllegalAccessException e) {
                throw new JsonGenerationException("Error reading field '" + field.getName() + "'", (Throwable)e);
            }
        }
    }

    private void serializeCustomFields(IssueFields issueFields, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        if (issueFields.fields != null) {
            for (Map.Entry<String, Object> customField : issueFields.fields.entrySet()) {
                Object value = customField.getValue();
                if (value instanceof String) {
                    jgen.writeStringField(customField.getKey(), (String)customField.getValue());
                    continue;
                }
                if (value instanceof Array) {
                    jgen.writeArrayFieldStart(customField.getKey());
                    for (String string : (String[])value) {
                        jgen.writeString(string);
                    }
                    jgen.writeEndArray();
                    continue;
                }
                jgen.writeObjectField(customField.getKey(), customField.getValue());
            }
        }
    }

    protected static boolean isPublic(Field field) {
        return (field.getModifiers() & 1) != 0;
    }
}

